<?php
// register post type Portfolio

add_action( 'init', 'register_fudee_Service' );
function register_fudee_Service() {
    
    $labels = array( 
        'name' => __( 'Service', 'fudee' ),
        'singular_name' => __( 'Service', 'fudee' ),
        'add_new' => __( 'Add New Service', 'fudee' ),
        'add_new_item' => __( 'Add New Service', 'fudee' ),
        'edit_item' => __( 'Edit Service', 'fudee' ),
        'new_item' => __( 'New Service', 'fudee' ),
        'view_item' => __( 'View Service', 'fudee' ),
        'search_items' => __( 'Search Service', 'fudee' ),
        'not_found' => __( 'No Service found', 'fudee' ),
        'not_found_in_trash' => __( 'No Service found in Trash', 'fudee' ),
        'parent_item_colon' => __( 'Parent Service:', 'fudee' ),
        'menu_name' => __( 'Service', 'fudee' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => true,
        'description' => 'List Service',
        'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),
        'taxonomies' => array( 'Service', 'type' ),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 5,
        'menu_icon'     => 'dashicons-admin-users',
        'show_in_nav_menus' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => false,
        'has_archive' => true,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => true,
        'capability_style' => 'post'
    );

    register_post_type( 'Service', $args );
}
add_action( 'init', 'create_ServiceType_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts

function create_ServiceType_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like Skills
//first do the translations part for GUI

  $labels = array(
    'name' => __( 'Type', 'fudee' ),
    'singular_name' => __( 'Type', 'fudee' ),
    'search_items' =>  __( 'Search Type','fudee' ),
    'all_items' => __( 'All Type','fudee' ),
    'parent_item' => __( 'Parent Type','fudee' ),
    'parent_item_colon' => __( 'Parent Type:','fudee' ),
    'edit_item' => __( 'Edit Type','fudee' ), 
    'update_item' => __( 'Update Type','fudee' ),
    'add_new_item' => __( 'Add New Type','fudee' ),
    'new_item_name' => __( 'New Type Name','fudee' ),
    'menu_name' => __( 'Type','fudee' ),
  );     

// Now register the taxonomy

  register_taxonomy('type',array('Service',), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'type' ),
  ));

}


add_action( 'init', 'register_fudee_Gallery' );
function register_fudee_Gallery() {
    
    $labels = array( 
        'name' => __( 'Gallery', 'fudee' ),
        'singular_name' => __( 'Gallery', 'fudee' ),
        'add_new' => __( 'Add New Gallery', 'fudee' ),
        'add_new_item' => __( 'Add New Gallery', 'fudee' ),
        'edit_item' => __( 'Edit Gallery', 'fudee' ),
        'new_item' => __( 'New Gallery', 'fudee' ),
        'view_item' => __( 'View Gallery', 'fudee' ),
        'search_items' => __( 'Search Gallery', 'fudee' ),
        'not_found' => __( 'No Gallery found', 'fudee' ),
        'not_found_in_trash' => __( 'No Gallery found in Trash', 'fudee' ),
        'parent_item_colon' => __( 'Parent Gallery:', 'fudee' ),
        'menu_name' => __( 'Gallery', 'fudee' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => true,
        'description' => 'List Gallery',
        'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),
        'taxonomies' => array( 'Gallery', 'type1' ),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 5,
        'menu_icon' => get_stylesheet_directory_uri(). '/img/admin_ico.png', 
        'show_in_nav_menus' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => false,
        'has_archive' => true,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => true,
        'capability_style' => 'post'
    );

    register_post_type( 'Gallery', $args );
}
add_action( 'init', 'create_GalleryType_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts

function create_GalleryType_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like Skills
//first do the translations part for GUI

  $labels = array(
    'name' => __( 'Type', 'fudee' ),
    'singular_name' => __( 'Type', 'fudee' ),
    'search_items' =>  __( 'Search Type','fudee' ),
    'all_items' => __( 'All Type','fudee' ),
    'parent_item' => __( 'Parent Type','fudee' ),
    'parent_item_colon' => __( 'Parent Type:','fudee' ),
    'edit_item' => __( 'Edit Type','fudee' ), 
    'update_item' => __( 'Update Type','fudee' ),
    'add_new_item' => __( 'Add New Type','fudee' ),
    'new_item_name' => __( 'New Type Name','fudee' ),
    'menu_name' => __( 'Type','fudee' ),
  );     

// Now register the taxonomy

  register_taxonomy('type1',array('Gallery',), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'type1' ),
  ));

}