<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsAbout extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-about';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'About Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'bdevs-about' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_about',
			[
				'label' => esc_html__( 'About', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'about_style_1'  => esc_html__( 'About Style 1', 'bdevs-elementor' ),
					'about_style_2' => esc_html__( 'About Style 2', 'bdevs-elementor' ),
				],
				'default'   => 'about_style_1',
			]
		);

		$this->add_control(
			'image',
			[
				'label'   => esc_html__( 'About Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your About Image', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'image_2',
			[
				'label'   => esc_html__( 'About Image 2', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your About Image 2', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'image_3',
			[
				'label'   => esc_html__( 'About Image 3', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your About Image 3', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'image_4',
			[
				'label'   => esc_html__( 'About Image 4', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your About Image 4', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'number_title',
			[
				'label'       => __( 'Number', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Number', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Title', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Subtitle', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your subtitle', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'button_link',
			[
				'label'       => __( 'Button Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your button link', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'button_text',
			[
				'label'       => __( 'Button Text', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your button text', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_about_2',
			[
				'label' => esc_html__( 'About Style 2', 'bdevs-elementor' ),
				
			]
		);

		$this->add_control(
			'image_style_2',
			[
				'label'   => esc_html__( 'About Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your About Image', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'image_2_style_2',
			[
				'label'   => esc_html__( 'About Image 2', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your About Image 2', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'icon_image_style_2',
			[
				'label'   => esc_html__( 'Icon Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Icon Image', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'seal_image_style_2',
			[
				'label'   => esc_html__( 'Seal Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Seal Image', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'heading_style_2',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'sub_heading_style_2',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'content_style_2',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'link_style_2',
			[
				'label'       => __( 'Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your link', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'button_style_2',
			[
				'label'       => __( 'Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your button', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'tabs_2',
			[
				'label' => esc_html__( 'About Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [	
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'About Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'About Subtitle' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_icon',
						'label'       => esc_html__( 'Tab Icon', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'show_image',
			[
				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();



	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		$chose_style = $settings['chose_style'];
		?>

		<?php if( $chose_style == 'about_style_1' ): ?>
		
		<div class="about-area pt-130 pb-130">

			<div class="container">

				<div class="row justify-content-center">

					<div class="col-xl-6 col-lg-8 col-md-10">

						<div class="section-title text-center">

							<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>

							<h5><?php echo wp_kses_post($settings['sub_heading']); ?></h5>

							<?php endif; ?>	

							<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>

							<h3><?php echo wp_kses_post($settings['heading']); ?></h3>

							<?php endif; ?>	

							<?php if (( '' !== $settings['image']['url'] ) && ( $settings['show_image'] )): ?>

							<div class="icon">

								<img src="<?php echo wp_kses_post($settings['image']['url']); ?>" alt="icon">

							</div>

							<?php endif; ?>	

						</div>

					</div>

				</div>

				<div class="row mt-80 align-items-center">

					<div class="col-xl-6 col-lg-6">

						<div class="about-thumb">

							<?php if ( '' !== $settings['image_2']['url'] ) : ?>

							<img src="<?php echo wp_kses_post($settings['image_2']['url']); ?>" alt="thumb">

							<?php endif; ?>	

							<?php if ( '' !== $settings['image_3']['url'] ) : ?>

							<span class="about-thumb-shape" style="background-image: url(<?php echo wp_kses_post($settings['image_3']['url']); ?>)">

								a

							</span>

							<?php endif; ?>	

						</div>

					</div>

					<div class="col-xl-6 col-lg-6">

						<div class="about-details mt-md-120 mt-xs-60">

							<?php if ( '' !== $settings['number_title'] ) : ?>

							<span class="about-num"><?php echo wp_kses_post($settings['number_title']); ?></span>

							<?php endif; ?>	

							<?php if ( '' !== $settings['title'] ) : ?>

							<h4><?php echo wp_kses_post($settings['title']); ?></h4>

							<?php endif; ?>	
							
							<?php if ( '' !== $settings['subtitle'] ) : ?>

							<p>

								<?php echo wp_kses_post($settings['subtitle']); ?>

							</p>

							<?php endif; ?>	

							<?php if ( '' !== $settings['button_text'] ) : ?>

							<a href="<?php echo wp_kses_post($settings['button_link']); ?>" class="a-btn btn-theme mt-45">

								<?php echo wp_kses_post($settings['button_text']); ?> <i class="fas fa-plus"></i>

							</a>

							<?php endif; ?>	

							<?php if ( '' !== $settings['image_4']['url'] ) : ?>

							<div class="about-seal">

								<img src="<?php echo wp_kses_post($settings['image_4']['url']); ?>" alt="seal">

							</div>

							<?php endif; ?>	

						</div>

					</div>

				</div>

			</div>

		</div>

		<?php elseif( $chose_style == 'about_style_2' ): ?>

			<div class="about-area pt-50 pb-180 pb-lg-130 pb-md-130 pb-xs-130">
				<div class="container">
					<div class="row mt-80 align-items-center">
						<div class="col-xl-6 col-lg-6">
							<div class="about-thumb">
								<?php if (( '' !== $settings['image_style_2']['url'] ) && ( $settings['show_image'] )): ?>
								<img src="<?php echo wp_kses_post($settings['image_style_2']['url']); ?>" alt="thumb">
								<?php endif; ?>	
								<?php if ( '' !== $settings['image_2_style_2']['url'] ) : ?>
								<span class="about-thumb-small">
									<img src="<?php echo wp_kses_post($settings['image_2_style_2']['url']); ?>" alt="">
								</span>
								<?php endif; ?>	
							</div>
						</div>
						<div class="col-xl-6 col-lg-6">
							<div class="about-details mt-md-120 mt-xs-60">
								<div class="section-title mb-20">
									<?php if (( '' !== $settings['sub_heading_style_2'] ) && ( $settings['show_sub_heading'] )): ?>

									<h5><?php echo wp_kses_post($settings['sub_heading_style_2']); ?></h5>

									<?php endif; ?>	

									<?php if (( '' !== $settings['heading_style_2'] ) && ( $settings['show_heading'] )): ?>

									<h3><?php echo wp_kses_post($settings['heading_style_2']); ?></h3>

									<?php endif; ?>	

									<?php if ( '' !== $settings['icon_image_style_2']['url'] ) : ?>

									<div class="icon">

										<img src="<?php echo wp_kses_post($settings['icon_image_style_2']['url']); ?>" alt="icon">

									</div>

									<?php endif; ?>	
								</div>
								<?php if (( '' !== $settings['content_style_2'] ) && ( $settings['show_content'] )): ?>
								<p>
									<?php echo wp_kses_post($settings['content_style_2']); ?>
								</p>
								<?php endif; ?>	
								
								<?php foreach ( $settings['tabs_2'] as $item ) : ?>

									<div class="about-feature">
										<?php if ( '' !== $item['tab_icon'] ) : ?>
										<div class="about-feature-icon">
											<i class="<?php echo wp_kses_post($item['tab_icon']); ?>"></i>
										</div>
										<?php endif; ?>	
										<div class="about-feature-content">
											<?php if ( '' !== $item['tab_title'] ) : ?>
											<h5><?php echo wp_kses_post($item['tab_title']); ?></h5>
											<?php endif; ?>	
											<?php if ( '' !== $item['tab_subtitle'] ) : ?>
											<p>
												<?php echo wp_kses_post($item['tab_subtitle']); ?>
											</p>
											<?php endif; ?>	
										</div>
									</div>

								<?php endforeach; ?> 

								<?php if (( '' !== $settings['button_style_2'] ) && ( $settings['show_button'] )): ?>
								<a href="<?php echo wp_kses_post($settings['link_style_2']); ?>" class="a-btn btn-theme mt-45">
									<?php echo wp_kses_post($settings['button_style_2']); ?> <i class="fas fa-plus"></i>
								</a>
								<?php endif; ?>	
								<?php if ( '' !== $settings['seal_image_style_2']['url'] ) : ?>
								<div class="about-seal">
									<img src="<?php echo wp_kses_post($settings['seal_image_style_2']['url']); ?>" alt="seal">
								</div>
								<?php endif; ?>	
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>	
	<?php
	}

}