<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsShop extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-shop';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Shop Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'bdevs-shop' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_shop',
			[
				'label' => esc_html__( 'Shop', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'image',
			[
				'label'   => esc_html__( 'Shop Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Shop Image', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'shape_image_1',
			[
				'label'   => esc_html__( 'Shape Image 1', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Shape Image 1', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'shape_image_2',
			[
				'label'   => esc_html__( 'Shape Image 2', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Shape Image 2', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'shape_image_3',
			[
				'label'   => esc_html__( 'Shape Image 3', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Shape Image 3', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'shape_image_4',
			[
				'label'   => esc_html__( 'Shape Image 4', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Shape Image 4', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'button_link',
			[
				'label'       => __( 'Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your link', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'button_text',
			[
				'label'       => __( 'Button Text', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your button bext', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'post_number',
			[
				'label'       => __( 'Post Number', 'bdevs-elementor' ),
				'type'        => Controls_Manager::NUMBER,
				'default'     => __( '4', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
				],
				'default'   => 'asc',
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'show_image',
			[
				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();


	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		/**
 * Template Name: Shop Sidebar
 * Description: A Page Template with a Page Builder design.
 *
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

	defined( 'ABSPATH' ) || exit;
	global $product;
		?>




		<div class="product-area product-area-shape product-filter-wrapper pt-130 pb-130">
			<div class="container">
				<div class="row justify-content-center mb-55">
					<div class="col-xl-6 col-lg-8 col-md-10">
						<div class="section-title text-center">
							<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>

							<h5><?php echo wp_kses_post($settings['sub_heading']); ?></h5>

						<?php endif; ?>	

						<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>

						<h3><?php echo wp_kses_post($settings['heading']); ?></h3>

					<?php endif; ?>	

					<?php if (( '' !== $settings['image']['url'] ) && ( $settings['show_image'] )): ?>

					<div class="icon">

						<img src="<?php echo wp_kses_post($settings['image']['url']); ?>" alt="icon">

					</div>

				<?php endif; ?>	
			</div>
		</div>
	</div>
	<div class="row mb-60">
		<div class="col-xl-12">
			<div class="product-filter-nav">
				<button class="active" data-filter="*">
					<i class="flaticon-vegetable"></i>
					<span><?php echo esc_html__( 'Vegetables', 'fudee' )?></span>
				</button>
				<?php  $categories = get_terms('product_cat'); 
				foreach( (array)$categories as $categorie){

					$cat_name = $categorie->name; 
					$cat_slug = $categorie->slug; 
					$cat_desc = $categorie->description; 
					?>
					<button data-filter=".<?php echo esc_attr($cat_slug);?>">
						<i class="<?php echo esc_attr($cat_desc);?>"></i>
						<span><?php echo esc_attr($cat_name);?></span>
					</button>
				<?php } ?>
			</div>
		</div>
	</div>
	<div class="row product-filter-grid">
		<?php 
		$order = $settings['post_order'];
		$post_number = $settings['post_number'];
		$wp_query = new \WP_Query(array('posts_per_page' => $post_number,'post_type' => 'product',  'orderby' => 'ID', 'order' => $order));
		

		while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
			global $post, $product;
			$cates = get_the_terms(get_the_ID(),'product_cat');
			$cate_name ='';
			$cate_slug ='';
			foreach((array)$cates as $cate){
				if(count($cates)>0){
					$cate_name .= $cate->name.' ';
					$cate_slug .= $cate->slug.' ';      
				} 
			} 
			;
			?> 
			<div class="col-xl-3 col-md-6 grid-item <?php echo esc_attr($cate_slug);?>">
				<div class="product-wrap">
					<div class="product-thumb">
						<?php
									  /**
									   * woocommerce_before_shop_loop_item hook.
									   *
									   * @hooked woocommerce_template_loop_product_link_open - 10
									   */
									  do_action( 'woocommerce_before_shop_loop_item' ); 

									  /**
									   * woocommerce_before_shop_loop_item_title hook.
									   *
									   * @hooked woocommerce_show_product_loop_sale_flash - 10
									   * @hooked woocommerce_template_loop_product_thumbnail - 10
									   */
									  do_action( 'woocommerce_before_shop_loop_item_title' );?>
									</div>
									<div class="product-details">
										<h5><a href="<?php the_permalink();?>"><?php the_title();?></a></h5>
										<?php 

									  /**
									   * woocommerce_after_shop_loop_item_title hook.
									   *
									   * @hooked woocommerce_template_loop_rating - 5
									   * @hooked woocommerce_template_loop_price - 10
									   */
									  do_action( 'woocommerce_after_shop_loop_item_title' ); ?>
									</div>
									<div class="product-hover">
										<ul class="product-btns">
											<li><a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>"><i class="far fa-expand"></i></a></li>
											<li><a href="<?php the_permalink();?>"><i class="far fa-heart"></i></a></li>
											<li><a href="#"><i class="far fa-repeat"></i></a></li>
										</ul>
										<?php 
					                  /**
					                   * woocommerce_after_shop_loop_item hook.
					                   *
					                   * @hooked woocommerce_template_loop_product_link_close - 5
					                   * @hooked woocommerce_template_loop_add_to_cart - 10
					                   */
					                  do_action( 'woocommerce_after_shop_loop_item' );
					                  ?>
					              </div>
					          </div>
					      </div>
					  <?php endwhile ?>
					</div>
					<?php if ( '' !== $settings['button_text'] ) : ?>
						<div class="row">
							<div class="col-xl-12 text-center">
								<a href="<?php echo wp_kses_post($settings['button_link']); ?>" class="a-btn btn-dark mt-50">
									<?php echo wp_kses_post($settings['button_text']); ?> <i class="fas fa-plus"></i>
								</a>
							</div>
						</div>
					<?php endif; ?>	
				</div>
				<?php if ( '' !== $settings['shape_image_1']['url'] ) : ?>
					<div class="shape-1">
						<img src="<?php echo wp_kses_post($settings['shape_image_1']['url']); ?>" alt="icon">
					</div>
				<?php endif; ?>	
				<?php if ( '' !== $settings['shape_image_2']['url'] ) : ?>
					<div class="shape-2">
						<img src="<?php echo wp_kses_post($settings['shape_image_2']['url']); ?>" alt="icon">
					</div>
				<?php endif; ?>	
				<?php if ( '' !== $settings['shape_image_3']['url'] ) : ?>
					<div class="shape-3">
						<img src="<?php echo wp_kses_post($settings['shape_image_3']['url']); ?>" alt="icon">
					</div>
				<?php endif; ?>	
				<?php if ( '' !== $settings['shape_image_4']['url'] ) : ?>
					<div class="shape-4">
						<img src="<?php echo wp_kses_post($settings['shape_image_4']['url']); ?>" alt="icon">
					</div>
				<?php endif; ?>	
			</div>


			<?php
		}

	}