<?php
/**
 * The template for displaying 404 pages (Not Found)
 */
$fudee_redux_demo = get_option('redux_demo');
get_header(); ?> 



<section class="title text-center page-404">
  <div class="container">
    <h2><?php if(isset($fudee_redux_demo['404_title']) && $fudee_redux_demo['404_title'] != ''){?>
                <?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['404_title']));?>
                <?php }else{?>
                <?php echo esc_html__( 'Error 404', 'fudee' );
                }?></h2>
    <h3><?php if(isset($fudee_redux_demo['404_subtitle']) && $fudee_redux_demo['404_subtitle'] != ''){?>
                <?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['404_subtitle']));?>
                <?php }else{?>
                <?php echo esc_html__( 'Oops! That page can’t be found', 'fudee' );
                }?></h3>
    <div class="text"><?php if(isset($fudee_redux_demo['404_desc']) && $fudee_redux_demo['404_desc'] != ''){?>
                <?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['404_desc']));?>
                <?php }else{?>
                <?php echo esc_html__( 'Sorry, but the page you are looking for does not existing', 'fudee' );
                }?></div>
    <a href="<?php echo esc_url(home_url('/')); ?>" class="btn btn-primary"><span class="btn-text"><?php if(isset($fudee_redux_demo['404_text']) && $fudee_redux_demo['404_text'] != ''){?>
                <?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['404_text']));?>
                <?php }else{?>
                <?php echo esc_html__( 'Go Home', 'fudee' );
                }?></span><span class="btn-border"></span></a>
  </div>
</section>

<?php get_footer(); ?>

