<?php
/**
 * Plugin Name: Meta Box
 * Plugin URI:  https://metabox.io
 * Description: Create custom meta boxes and custom fields in WordPress.
 * Version:     5.3.3
 * Author:      MetaBox.io
 * Author URI:  https://metabox.io
 * License:     GPL2+
 * Text Domain: meta-box
 * Domain Path: /languages/
 *
 * @package Meta Box
 */

if ( defined( 'ABSPATH' ) && ! defined( 'RWMB_VER' ) ) {
    register_activation_hook( __file__, 'rwmb_check_php_version' );

    /**
     * Display notice for old PHP version.
     */
    function rwmb_check_php_version() {
        if ( version_compare( phpversion(), '5.3', '<' ) ) {
            die( esc_html__( 'Meta Box requires PHP version 5.3+. Please contact your host to upgrade.', 'meta-box' ) );
        }
    }




    require_once dirname( __file__ ) . '/inc/loader.php';
    $rwmb_loader = new RWMB_Loader();
    $rwmb_loader->init();


    add_filter( 'rwmb_meta_boxes', function ( $meta_boxes ) {

    $prefix = '_cmb_';


  // Open Code

    $meta_boxes[] = array(
        'id'         => 'post_setting',
        'title'      => 'Post Setting',
        'pages'      => array('post'), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox
        'fields' => array(
            array(
                'name' => 'Facebook',
                'desc' => 'Input link facebook',
                'default' => '',
                'id' => $prefix . 'single_facebook',
                'type' => 'text'
            ), 
            array(
                'name' => 'Twitter',
                'desc' => 'Input link twitter',
                'default' => '',
                'id' => $prefix . 'single_twitter',
                'type' => 'text'
            ),
            array(
                'name' => 'Behance',
                'desc' => 'Input link behance',
                'default' => '',
                'id' => $prefix . 'single_behance',
                'type' => 'text'
            ),
            array(
                'name' => 'Youtube',
                'desc' => 'Input link youtube',
                'default' => '',
                'id' => $prefix . 'single_youtube',
                'type' => 'text'
            ),
            array(
                'name' => 'Vimeo',
                'desc' => 'Input link vimeo',
                'default' => '',
                'id' => $prefix . 'single_vimeo',
                'type' => 'text'
            ),
            array(
                'name' => 'Recent Title',
                'desc' => 'Input Recent Title',
                'default' => '',
                'id' => $prefix . 'recent_title',
                'type' => 'text'
            ), 
            array(
                'name' => 'Recent Image',
                'desc' => 'Image Upload',
                'default' => '',
                'id' => $prefix . 'recent_image',
                'type' => 'single_image'
            ),
            array(
                'name' => 'Home Title',
                'desc' => 'Input Home Title',
                'default' => '',
                'id' => $prefix . 'home_title',
                'type' => 'text'
            ), 
            array(
                'name' => 'Home Subtitle',
                'desc' => 'Input Home Subtitle',
                'default' => '',
                'id' => $prefix . 'home_subtitle',
                'type' => 'text'
            ), 
            array(
                'name' => 'Home Image',
                'desc' => 'Image Home Upload',
                'default' => '',
                'id' => $prefix . 'home_image',
                'type' => 'single_image'
            ),
            array(
                'name' => 'Home 3 Image',
                'desc' => 'Image Home 3 Upload',
                'default' => '',
                'id' => $prefix . 'image_home3',
                'type' => 'single_image'
            ),
        )
    );


    $meta_boxes[] = array(
        'id'         => 'post_setting',
        'title'      => 'Post Setting',
        'pages'      => array('service'), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox
        'fields' => array(
            array(
                'name' => 'Service Icon',
                'desc' => 'Input Service Icon',
                'default' => '',
                'id' => $prefix . 'service_icon',
                'type' => 'text'
            ), 
            array(
                'name' => 'Service Image',
                'desc' => 'Input Service Image',
                'default' => '',
                'id' => $prefix . 'service_image',
                'type' => 'single_image'
            ), 
            array(
                'name' => 'Service Excerpt',
                'desc' => 'Input Service Excerpt',
                'default' => '',
                'id' => $prefix . 'service_excerpt',
                'type' => 'text'
            ),
        )
    );


    $meta_boxes[] = array(
        'id'         => 'post_setting',
        'title'      => 'Post Setting',
        'pages'      => array('gallery'), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox
        'fields' => array(
            array(
                'name' => 'Type',
                'desc' => 'Input Gallery Type',
                'default' => '',
                'id' => $prefix . 'gallery_type',
                'type' => 'text'
            ), 
            array(
                'name' => 'Type 2',
                'desc' => 'Input Gallery Type 2',
                'default' => '',
                'id' => $prefix . 'gallery_type_2',
                'type' => 'text'
            ), 
            array(
                'name' => 'Gallery Image',
                'desc' => 'Image Gallery Upload',
                'default' => '',
                'id' => $prefix . 'gallery_image',
                'type' => 'single_image'
            ),
            array(
                'name' => 'Gallery Area Image',
                'desc' => 'Image Gallery Area Upload',
                'default' => '',
                'id' => $prefix . 'gallery_area_image',
                'type' => 'single_image'
            ),
        )
    );


    

    



// End Code
    return $meta_boxes;
});
}