<?php

namespace BdevsElementor\Widget;



use Elementor\Controls_Manager;

use Elementor\Group_Control_Typography;

use Elementor\Scheme_Typography;

use Elementor\Group_Control_Border;

use Elementor\Group_Control_Box_Shadow;



/**

 * Bdevs Elementor Widget.

 *

 * Elementor widget that inserts an embbedable content into the page, from any given URL.

 *

 * @since 1.0.0

 */

class BdevsTestimonials extends \Elementor\Widget_Base {



	/**

	 * Get widget name.

	 *

	 * Retrieve Bdevs Elementor widget name.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget name.

	 */

	public function get_name() {

		return 'bdevs-testimonials';

	}



	/**

	 * Get widget title.

	 *

	 * Retrieve Bdevs Elementor widget title.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget title.

	 */

	public function get_title() {

		return __( 'Testimonials Widget', 'bdevs-elementor' );

	}



	/**

	 * Get widget icon.

	 *

	 * Retrieve Bdevs Slider widget icon.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget icon.

	 */

	public function get_icon() {

		return 'eicon-favorite';

	}



	/**

	 * Get widget categories.

	 *

	 * Retrieve the list of categories the Bdevs Slider widget belongs to.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return array Widget categories.

	 */

	public function get_categories() {

		return [ 'bdevs-elementor' ];

	}



	public function get_keywords() {

		return [ 'bdevs-testimonials' ];

	}



	public function get_script_depends() {

		return [ 'bdevs-elementor'];

	}



	// BDT Position

	protected function element_pack_position() {

	    $position_options = [

	        ''              => esc_html__('Default', 'bdevs-elementor'),

	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,

	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,

	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,

	        'center'        => esc_html__('Center', 'bdevs-elementor') ,

	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,

	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,

	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,

	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,

	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,

	    ];



	    return $position_options;

	}



	protected function _register_controls() {

		$this->start_controls_section(

			'section_content_testimonials',

			[

				'label' => esc_html__( 'Testimonials Area', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'chose_style',

			[

				'label'     => esc_html__( 'Chose Style', 'bdevs-elementor' ),

				'type'      => Controls_Manager::SELECT,

				'options'   => [

					'testimonials_style_1'  => esc_html__( 'Testimonials Style 1', 'bdevs-elementor' ),

					'testimonials_style_2' => esc_html__( 'Testimonials Style 2', 'bdevs-elementor' ),

					'testimonials_style_3' => esc_html__( 'Testimonials Style 3', 'bdevs-elementor' ),

				],

				'default'   => 'testimonials_style_1',

			]

		);



		$this->add_control(

			'image',

			[

				'label'   => esc_html__( 'Testimonials Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Testimonials Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'image_2',

			[

				'label'   => esc_html__( 'Testimonials Image 2', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Testimonials Image 2', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'heading',

			[

				'label'       => __( 'Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->add_control(

			'sub_heading',

			[

				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'tabs',

			[

				'label' => esc_html__( 'Testimonial Items', 'bdevs-elementor' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => [

					[

						'name'        => 'stars_select',

						'label'     => esc_html__( 'Stars Select', 'bdevs-elementor' ),

						'type'      => Controls_Manager::SELECT,

						'dynamic' => [ 'active' => true ],

						'options'   => [

							'1'  => esc_html__( '1 Star', 'bdevs-elementor' ),

							'2'  => esc_html__( '2 Stars', 'bdevs-elementor' ),

							'3'  => esc_html__( '3 Stars', 'bdevs-elementor' ),

							'4'  => esc_html__( '4 Stars', 'bdevs-elementor' ),

							'5'  => esc_html__( '5 Stars', 'bdevs-elementor' ),

						],

						'default'   => '5',

					],

					[

						'name'    => 'tab_image',

						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),

						'type'    => Controls_Manager::MEDIA,

						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),

					],

					[

						'name'        => 'tab_title',

						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_subtitle',

						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_desc',

						'label'       => esc_html__( 'Description', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXTAREA,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

				],

			]

		);



		$this->end_controls_section();





		$this->start_controls_section(

			'section_content_testimonials_2',

			[

				'label' => esc_html__( 'Testimonials Style 2', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'image_style_2',

			[

				'label'   => esc_html__( 'Testimonials Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Testimonials Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'image_2_style_2',

			[

				'label'   => esc_html__( 'Testimonials Image 2', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Testimonials Image 2', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'tabs_2',

			[

				'label' => esc_html__( 'Testimonial Items', 'bdevs-elementor' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => [

					[

						'name'    => 'tab_image',

						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),

						'type'    => Controls_Manager::MEDIA,

						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),

					],

					[

						'name'    => 'icon_image',

						'label'   => esc_html__( 'Icon Image', 'bdevs-elementor' ),

						'type'    => Controls_Manager::MEDIA,

						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),

					],

					[

						'name'    => 'author_image',

						'label'   => esc_html__( 'Author Image', 'bdevs-elementor' ),

						'type'    => Controls_Manager::MEDIA,

						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),

					],

					[

						'name'        => 'tab_title',

						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_subtitle',

						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_desc',

						'label'       => esc_html__( 'Description', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXTAREA,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

				],

			]

		);



		$this->end_controls_section();







		$this->start_controls_section(

			'section_content_testimonials_3',

			[

				'label' => esc_html__( 'Testimonials Style 3', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'image_style_3',

			[

				'label'   => esc_html__( 'Testimonials Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Testimonials Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'heading_style_3',

			[

				'label'       => __( 'Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->add_control(

			'sub_heading_style_3',

			[

				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'tabs_3',

			[

				'label' => esc_html__( 'Testimonial Items', 'bdevs-elementor' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => [

					[

						'name'        => 'stars_select',

						'label'     => esc_html__( 'Stars Select', 'bdevs-elementor' ),

						'type'      => Controls_Manager::SELECT,

						'dynamic' => [ 'active' => true ],

						'options'   => [

							'1'  => esc_html__( '1 Star', 'bdevs-elementor' ),

							'2'  => esc_html__( '2 Stars', 'bdevs-elementor' ),

							'3'  => esc_html__( '3 Stars', 'bdevs-elementor' ),

							'4'  => esc_html__( '4 Stars', 'bdevs-elementor' ),

							'5'  => esc_html__( '5 Stars', 'bdevs-elementor' ),

						],

						'default'   => '5',

					],

					[

						'name'    => 'tab_image',

						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),

						'type'    => Controls_Manager::MEDIA,

						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),

					],

					[

						'name'    => 'author_image',

						'label'   => esc_html__( 'Author Image', 'bdevs-elementor' ),

						'type'    => Controls_Manager::MEDIA,

						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),

					],

					[

						'name'        => 'tab_title',

						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_subtitle',

						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_desc',

						'label'       => esc_html__( 'Description', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXTAREA,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

				],

			]

		);



		$this->end_controls_section();







		$this->start_controls_section(

			'section_content_layout',

			[

				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),

			]

		);



		$this->add_responsive_control(

			'align',

			[

				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),

				'type'    => Controls_Manager::CHOOSE,

				'options' => [

					'left' => [

						'title' => esc_html__( 'Left', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-left',

					],

					'center' => [

						'title' => esc_html__( 'Center', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-center',

					],

					'right' => [

						'title' => esc_html__( 'Right', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-right',

					],

					'justify' => [

						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-justify',

					],

				],

				'prefix_class' => 'elementor%s-align-',

				'description'  => 'Use align to match position',

				'default'      => 'center',

			]

		);



		$this->add_control(

			'show_heading',

			[

				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);	



		$this->add_control(

			'show_sub_heading',

			[

				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);		



		$this->add_control(

			'show_image',

			[

				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);





		$this->end_controls_section();







	}



	public function render() {

		$settings  = $this->get_settings_for_display();

		$chose_style = $settings['chose_style'];

		?>

		

		<?php if( $chose_style == 'testimonials_style_1' ): ?>



		<div class="testimonial-area testimonial-area pt-120 pb-150">



			<div class="container">



				<div class="row justify-content-end">

					<div class="col-xl-6">



						<div class="section-title mb-50">



							<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>



							<h5><?php echo wp_kses_post($settings['sub_heading']); ?></h5>



							<?php endif; ?>	



							<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>



							<h3><?php echo wp_kses_post($settings['heading']); ?></h3>



							<?php endif; ?>	



							<?php if (( '' !== $settings['image']['url'] ) && ( $settings['show_image'] )): ?>



							<div class="icon">



								<img src="<?php echo wp_kses_post($settings['image']['url']); ?>" alt="icon">



							</div>



							<?php endif; ?>	



						</div>



						<div class="testimonial-slider testimonial-slider-3">



							<?php foreach ( $settings['tabs'] as $item ) : ?>



							<div class="testimonial-slide">



								<div class="testimonial-details">



									<div class="testimonial-content">

										<div class="rating">



											<?php if(wp_kses_post($item['stars_select'])=='1') { ?>

                                                <i class="fas fa-star"></i>

                                            <?php } elseif(wp_kses_post($item['stars_select'])=='2') { ?>

                                                <i class="fas fa-star"></i>

                                                <i class="fas fa-star"></i>

                                            <?php } elseif(wp_kses_post($item['stars_select'])=='3') { ?>

                                                <i class="fas fa-star"></i>

                                                <i class="fas fa-star"></i>

                                                <i class="fas fa-star"></i>

                                            <?php } elseif(wp_kses_post($item['stars_select'])=='4') { ?>

                                                <i class="fas fa-star"></i>

                                                <i class="fas fa-star"></i>

                                                <i class="fas fa-star"></i>

                                                <i class="fas fa-star"></i>

                                            <?php }else{ ?>

                                                <i class="fas fa-star"></i>

                                                <i class="fas fa-star"></i>

                                                <i class="fas fa-star"></i>

                                                <i class="fas fa-star"></i>

                                                <i class="fas fa-star"></i>

                                            <?php } ?>



										</div>



										<?php if ( '' !== $item['tab_desc'] ) : ?>

										<p><?php echo wp_kses_post($item['tab_desc']); ?></p>

										<?php endif; ?>



									</div>



									<div class="author-wrap">



										<?php if ( '' !== $item['tab_image']['url'] ) : ?>



										<div class="author-thumb">



											<img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt="author">



										</div>



										<?php endif; ?>



										<div class="author-text">

											

											<?php if ( '' !== $item['tab_title'] ) : ?>

											<h5><?php echo wp_kses_post($item['tab_title']); ?></h5>

											<?php endif; ?>

											

											<?php if ( '' !== $item['tab_subtitle'] ) : ?>

											<p><?php echo wp_kses_post($item['tab_subtitle']); ?></p>

											<?php endif; ?>



										</div>



									</div>



								</div>



							</div>



							<?php endforeach; ?>



						</div>

					</div>



				</div>



			</div>

			<?php if ( '' !== $settings['image_2']['url'] ) : ?>



			<div class="testimonial-img-3">



				<img src="<?php echo wp_kses_post($settings['image_2']['url']); ?>" alt="author">



			</div>



			<?php endif; ?>



		</div>



		<?php elseif( $chose_style == 'testimonials_style_2' ): ?>



			<div class="testimonial-area-2 pt-130 pb-130">



				<div class="container">



					<div class="row">



						<div class="col-xl-12">



							<div class="testimonial-slider-2">



								<?php foreach ( $settings['tabs_2'] as $item ) : ?>



									<div class="testimonial-slide-2">



										<div class="row justify-content-center align-items-center">



											<div class="col-xl-5 col-lg-5 col-md-6">



												<?php if ( '' !== $item['tab_image']['url'] ) : ?>



													<div class="testimonial-img">



														<img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt="author">



													</div>



												<?php endif; ?>



											</div>



											<div class="col-xl-7 col-lg-7 col-md-12">



												<div class="testimonial-details">



													<?php if ( '' !== $item['icon_image']['url'] ) : ?>



														<div class="icon">



															<img src="<?php echo wp_kses_post($item['icon_image']['url']); ?>" alt="icon">



														</div>



													<?php endif; ?>



													<?php if ( '' !== $item['tab_desc'] ) : ?>



														<p>



															<?php echo wp_kses_post($item['tab_desc']); ?>



														</p>



													<?php endif; ?>



													<div class="author-wrap">



														<?php if ( '' !== $item['author_image']['url'] ) : ?>



															<div class="author-thumb">



																<img src="<?php echo wp_kses_post($item['author_image']['url']); ?>" alt="author">



															</div>



														<?php endif; ?>



														<div class="author-text">



															<?php if ( '' !== $item['tab_title'] ) : ?>

																<h5><?php echo wp_kses_post($item['tab_title']); ?></h5>

															<?php endif; ?>



															<?php if ( '' !== $item['tab_subtitle'] ) : ?>

																<p><?php echo wp_kses_post($item['tab_subtitle']); ?></p>

															<?php endif; ?>



														</div>



													</div>



												</div>



											</div>



										</div>



									</div>



								<?php endforeach; ?>



							</div>



						</div>



					</div>



				</div>



				<?php if (( '' !== $settings['image_style_2']['url'] ) && ( $settings['show_image'] )): ?>



				<div class="testimonial-thumb-1">



					<img src="<?php echo wp_kses_post($settings['image_style_2']['url']); ?>" alt="thumb">



				</div>



			<?php endif; ?>	



			<?php if ( '' !== $settings['image_2_style_2']['url'] ) : ?>



				<div class="testimonial-thumb-2">



					<img src="<?php echo wp_kses_post($settings['image_2_style_2']['url']); ?>" alt="thumb">



				</div>



			<?php endif; ?>	



		</div>



		<?php elseif( $chose_style == 'testimonials_style_3' ): ?>



			<div class="testimonial-area pt-130 pb-130">

				<div class="container">

					<div class="row justify-content-center mb-50">

						<div class="col-xl-5 col-lg-6 col-md-10">

							<div class="section-title text-center">

								<?php if (( '' !== $settings['sub_heading_style_3'] ) && ( $settings['show_sub_heading'] )): ?>



								<h5><?php echo wp_kses_post($settings['sub_heading_style_3']); ?></h5>



							<?php endif; ?>	



							<?php if (( '' !== $settings['heading_style_3'] ) && ( $settings['show_heading'] )): ?>



							<h3><?php echo wp_kses_post($settings['heading_style_3']); ?></h3>



						<?php endif; ?>	



						<?php if (( '' !== $settings['image_style_3']['url'] ) && ( $settings['show_image'] )): ?>



						<div class="icon">



							<img src="<?php echo wp_kses_post($settings['image_style_3']['url']); ?>" alt="icon">



						</div>



					<?php endif; ?>	

				</div>

			</div>

		</div>

		<div class="row">

			<div class="col-xl-12">

				<div class="testimonial-slider">



					<?php foreach ( $settings['tabs_3'] as $item ) : ?>



						<div class="testimonial-slide">

							<div class="row justify-content-center align-items-center">

								<div class="col-xl-4 col-lg-4 d-none d-xl-block d-lg-block">

									<?php if ( '' !== $item['tab_image']['url'] ) : ?>

										<div class="testimonial-img">

											<img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt="author">

										</div>

										<?php endif; ?>

									</div>

									<div class="col-xl-6 col-lg-8 col-md-10">

										<div class="testimonial-details">

											<div class="rating">

												<?php if(wp_kses_post($item['stars_select'])=='1') { ?>

													<i class="fas fa-star"></i>

												<?php } elseif(wp_kses_post($item['stars_select'])=='2') { ?>

													<i class="fas fa-star"></i>

													<i class="fas fa-star"></i>

												<?php } elseif(wp_kses_post($item['stars_select'])=='3') { ?>

													<i class="fas fa-star"></i>

													<i class="fas fa-star"></i>

													<i class="fas fa-star"></i>

												<?php } elseif(wp_kses_post($item['stars_select'])=='4') { ?>

													<i class="fas fa-star"></i>

													<i class="fas fa-star"></i>

													<i class="fas fa-star"></i>

													<i class="fas fa-star"></i>

												<?php }else{ ?>

													<i class="fas fa-star"></i>

													<i class="fas fa-star"></i>

													<i class="fas fa-star"></i>

													<i class="fas fa-star"></i>

													<i class="fas fa-star"></i>

												<?php } ?>

											</div>

											<?php if ( '' !== $item['tab_desc'] ) : ?>

												<p><?php echo wp_kses_post($item['tab_desc']); ?></p>

											<?php endif; ?>

											<div class="author-wrap">



												<?php if ( '' !== $item['author_image']['url'] ) : ?>

													<div class="author-thumb">

														<img src="<?php echo wp_kses_post($item['author_image']['url']); ?>" alt="author">

													</div>

												<?php endif; ?>



												<div class="author-text">

													<?php if ( '' !== $item['tab_title'] ) : ?>

														<h5><?php echo wp_kses_post($item['tab_title']); ?></h5>

													<?php endif; ?>



													<?php if ( '' !== $item['tab_subtitle'] ) : ?>

														<p><?php echo wp_kses_post($item['tab_subtitle']); ?></p>

													<?php endif; ?>

												</div>

											</div>

										</div>

									</div>

								</div>

							</div>



						<?php endforeach; ?>



					</div>

				</div>

			</div>

		</div>

	</div>



<?php endif; ?>

<?php if (is_admin()) { ?>
<script type="text/javascript">
	if (jQuery(".testimonial-slider").length > 0) {

		$('.testimonial-slider').slick({

			slidesToShow: 1,

			slidesToScroll: 1,

			autoplay: true,

			autoplaySpeed: 10000,

			dots: true,

			arrows: true,

			prevArrow: '<button type="button" class="slick-prev"><i class="far fa-arrow-left"></i></button>',

			nextArrow: '<button type="button" class="slick-next"><i class="far fa-arrow-right"></i></i></button>',

		});

	}

	

	if (jQuery(".testimonial-slider-2").length > 0) {

		$('.testimonial-slider-2').slick({

			slidesToShow: 1,

			slidesToScroll: 1,

			autoplay: true,

			autoplaySpeed: 10000,

			dots: false,

			arrows: true,

			prevArrow: '<button type="button" class="slick-prev"><i class="far fa-arrow-left"></i></button>',

			nextArrow: '<button type="button" class="slick-next"><i class="far fa-arrow-right"></i></i></button>',

		});

	}
</script>
<?php }  ?>

	<?php

	}



}