<?php
/*
 * Template Name: Blog Grid
 * Description: A Page Template with a Page Builder design.
 */
 $fudee_redux_demo = get_option('redux_demo');
get_header(); ?>

<?php if(isset($fudee_redux_demo['blog_image']['url']) && $fudee_redux_demo['blog_image']['url'] != ''){?> 
<section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo esc_url($fudee_redux_demo['blog_image']['url']);?>)">
<?php }else{?>
<section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo (get_template_directory_uri().'/assets/img/bg/breadcrumb-bg.jpg');?>)">
<?php } ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-8 text-center">
            <div class="breadcrumb-content">
                <h3 class="title"><?php if(isset($fudee_redux_demo['blog_title']) && $fudee_redux_demo['blog_title'] != ''){?>
                    <?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['blog_title']));?>
                    <?php }else{?>
                    <?php echo esc_html__( 'Blog Standards', 'fudee' );
                    }
                    ?></h3>
                <ul>
                    <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__( 'home', 'fudee' );?></a></li>
                    <li class="active"><?php if(isset($fudee_redux_demo['blog_title']) && $fudee_redux_demo['blog_title'] != ''){?>
                    <?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['blog_title']));?>
                    <?php }else{?>
                    <?php echo esc_html__( 'Blog Standards', 'fudee' );
                    }
                    ?></li>
                </ul>
            </div>
        </div>
    </div>
</div>
</section>
<!--    breadcrumb-area end    -->

<!--    about-area start    -->
<div class="blog-grid-area pt-130 pb-100">
		<div class="container">
			<div class="row">
				<?php 
				$args = array(   
					'post_type' => 'post', 
				);  
				$wp_query = new WP_Query($args);
				while ($wp_query -> have_posts()) : $wp_query -> the_post();    
					?>  
					<div class="col-xl-4 col-lg-6">
						<div class="blog-box-wrap">
							<div class="blog-box-thumb">
								<a href="<?php the_permalink();?>">
									<img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="blog">
								</a>
							</div>
							<div class="blog-box-details">
								<h4>
									<a href="<?php the_permalink();?>"><?php the_title();?></a>
								</h4>
								<p>
                                <?php if(isset($fudee_redux_demo['blog_excerpt'])){?>
                                    <?php echo esc_attr(fudee_excerpt2($fudee_redux_demo['blog_excerpt'])); ?>
                                    <?php }else{?>
                                    <?php echo esc_attr(fudee_excerpt2(12)); 
                                    }?>
                            	</p>
								<a href="<?php the_permalink();?>" class="read-more"><?php if(isset($fudee_redux_demo['read_more'])){?>
									<?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['read_more']));?>
								<?php }else{?>
									<?php echo esc_html__( 'Read more', 'fudee' );
								}
								?> <i class="far fa-angle-right"></i></a>
							</div>
						</div>
					</div>
				<?php endwhile; ?>
			</div>
			<div class="row">
				<div class="col-xl-12">
					<div class="blog-pagination text-center">
						<?php fudee_pagination();?>
					</div>
				</div>
			</div>
		</div>
	</div>

<?php get_footer(); ?>