<?php
/*
 * Template Name: Home 1 Template
 * Description: A Page Template with a Page Builder design.
 */
 $fudee_redux_demo = get_option('redux_demo');
get_header(); ?>

<div class="slider-area">
		<div class="home-slider">
			<div class="home-slide" style="background-image: url(<?php echo get_template_directory_uri();?>/assets/img/slider/slider-1.jpg)">
				<div class="container">
					<div class="row justify-content-xl-start justify-content-lg-start justify-content-center">
						<div class="col-xl-7 col-lg-8 col-md-10">
							<div class="home-slide-text">
								<div class="home-slide-cat" data-animation="fadeInDown" data-delay="0.5s">
									<a href="blog.html">Food & Vegetables</a>
								</div>
								<div class="home-slide-title" data-animation="fadeInDown" data-delay="0.8s">
									<h3><span>Organic</span> Food Providers</h3>
								</div>
								<div class="home-slide-btn" data-animation="fadeInDown" data-delay="1.1s">
									<a href="blog.html" class="a-btn">learn more <i class="fas fa-plus"></i></a>
									<a href="https://www.youtube.com/watch?v=oF5y2uLFoX0" class="play-btn popup-video">
										<i class="far fa-play-circle"></i>
										<span>watch videos</span>
									</a>
								</div>
								<div class="home-slide-shape" data-animation="zoomIn" data-delay="0.2s">
									<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
									     width="659px" height="657px">
										<path fill-rule="evenodd" fill="rgb(255, 255, 255)"
										      d="M404.619,98.175 C435.465,137.384 470.409,169.818 506.015,194.454 C541.384,219.602 577.416,236.952 604.940,257.895 C632.599,278.653 651.758,302.991 656.547,337.786 C661.846,371.693 652.776,416.057 635.756,456.388 C562.446,626.457 369.620,701.287 201.054,630.161 C32.989,558.367 -44.639,362.971 27.363,195.425 C45.542,152.856 71.175,116.687 102.501,84.718 C133.643,53.202 170.478,25.887 206.801,11.504 C243.244,-3.033 279.180,-4.649 311.323,11.602 C343.892,27.086 372.668,60.438 404.619,98.175 L404.619,98.175 Z"/>
									</svg>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="home-slide" style="background-image: url(<?php echo get_template_directory_uri();?>/assets/img/slider/slider-1.jpg)">
				<div class="container">
					<div class="row justify-content-xl-start justify-content-lg-start justify-content-center">
						<div class="col-xl-7 col-lg-8 col-md-10">
							<div class="home-slide-text">
								<div class="home-slide-cat" data-animation="fadeInDown" data-delay="0.5s">
									<a href="<?php echo esc_url(home_url('/')); ?>?page_id=44">Food & Vegetables</a>
								</div>
								<div class="home-slide-title" data-animation="fadeInDown" data-delay="0.8s">
									<h3><span>Organic</span> Food Providers</h3>
								</div>
								<div class="home-slide-btn" data-animation="fadeInDown" data-delay="1.1s">
									<a href="<?php echo esc_url(home_url('/')); ?>?page_id=60" class="a-btn">learn more <i class="fas fa-plus"></i></a>
									<a href="https://www.youtube.com/watch?v=oF5y2uLFoX0" class="play-btn popup-video"><i class="far fa-play-circle"></i>
										<span>watch videos</span></a>
								</div>
								<div class="home-slide-shape" data-animation="zoomIn" data-delay="0.2s">
									<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
									     width="659px" height="657px">
										<path fill-rule="evenodd" fill="rgb(255, 255, 255)"
										      d="M404.619,98.175 C435.465,137.384 470.409,169.818 506.015,194.454 C541.384,219.602 577.416,236.952 604.940,257.895 C632.599,278.653 651.758,302.991 656.547,337.786 C661.846,371.693 652.776,416.057 635.756,456.388 C562.446,626.457 369.620,701.287 201.054,630.161 C32.989,558.367 -44.639,362.971 27.363,195.425 C45.542,152.856 71.175,116.687 102.501,84.718 C133.643,53.202 170.478,25.887 206.801,11.504 C243.244,-3.033 279.180,-4.649 311.323,11.602 C343.892,27.086 372.668,60.438 404.619,98.175 L404.619,98.175 Z"/>
									</svg>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--    slider-area end    -->

	<!--    service-area start    -->
	<div class="service-area">
		<div class="container-fluid px-0">
			<div class="row no-gutters">
				<div class="col-xl-3 col-md-6">
					<div class="service-wrap">
						<div class="service-icon">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-1.png" alt="icon">
						</div>
						<div class="service-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?service=organic-food">Organic Food</a></h4>
							<p>
								Sed ut perspiciatis omnis iste
								natus error sit voluptate accusa
								ntiuy dolorem laudantium
							</p>
						</div>
						<div class="service-shape"></div>
					</div>
				</div>
				<div class="col-xl-3 col-md-6">
					<div class="service-wrap">
						<div class="service-icon">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-2.png" alt="icon">
						</div>
						<div class="service-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?service=gardening">Gardening</a></h4>
							<p>
								Sed ut perspiciatis omnis iste
								natus error sit voluptate accusa
								ntiuy dolorem laudantium
							</p>
						</div>
						<div class="service-shape"></div>
					</div>
				</div>
				<div class="col-xl-3 col-md-6">
					<div class="service-wrap">
						<div class="service-icon">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-3.png" alt="icon">
						</div>
						<div class="service-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?service=fresh-organic">Fresh & Organic</a></h4>
							<p>
								Sed ut perspiciatis omnis iste
								natus error sit voluptate accusa
								ntiuy dolorem laudantium
							</p>
						</div>
						<div class="service-shape"></div>
					</div>
				</div>
				<div class="col-xl-3 col-md-6">
					<div class="service-wrap">
						<div class="service-icon">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-4.png" alt="icon">
						</div>
						<div class="service-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?service=landscaping">Landscaping</a></h4>
							<p>
								Sed ut perspiciatis omnis iste
								natus error sit voluptate accusa
								ntiuy dolorem laudantium
							</p>
						</div>
						<div class="service-shape"></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--    service-area end    -->

	<!--    about-area start    -->
	<div class="about-area pt-130 pb-130">
		<div class="container">
			<div class="row justify-content-center">
				<div class="col-xl-6 col-lg-8 col-md-10">
					<div class="section-title text-center">
						<h5>About Us</h5>
						<h3>We're Global Food Delivery Organic Company</h3>
						<div class="icon">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-5.png" alt="icon">
						</div>
					</div>
				</div>
			</div>
			<div class="row mt-80 align-items-center">
				<div class="col-xl-6 col-lg-6">
					<div class="about-thumb">
						<img src="<?php echo get_template_directory_uri();?>/assets/img/thumb/thumb-1.jpg" alt="thumb">
						<span class="about-thumb-shape" style="background-image: url(<?php echo get_template_directory_uri();?>/assets/img/thumb/thumb-2.jpg)">
							a
						</span>
					</div>
				</div>
				<div class="col-xl-6 col-lg-6">
					<div class="about-details mt-md-120 mt-xs-60">
						<span class="about-num">25</span>
						<h4>Years Since We Provide Organic Food & Vegetables For Golbal Agency</h4>
						<p>
							Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque
							laudanti totam aperiam eaque ipsa quae ab illo inventore veritatis et architecto beatae
							vitae dicta sunt explicabo. Nemoes enim ipsam voluptatem volup aspernatur
						</p>
						<a href="<?php echo esc_url(home_url('/')); ?>?page_id=60" class="a-btn btn-theme mt-45">
							learn more <i class="fas fa-plus"></i>
						</a>
						<div class="about-seal">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/shape/seal.png" alt="seal">
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--    about-area end    -->

	<!--    service-area start    -->
	<div class="service-area service-area-2 pt-130 pb-130" style="background-image: url(<?php echo get_template_directory_uri();?>/assets/img/shape/shape-1.png)">
		<div class="container">
			<div class="row justify-content-center mb-55">
				<div class="col-xl-6 col-lg-8 col-md-10">
					<div class="section-title text-center">
						<h5>What We Do</h5>
						<h3>Services We Provide That Benifited Health</h3>
						<div class="icon">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-5.png" alt="icon">
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xl-4 col-md-6">
					<div class="service-wrap-2">
						<div class="service-thumb">
							<a href="<?php echo esc_url(home_url('/')); ?>??service=fresh-organic">
								<img src="<?php echo get_template_directory_uri();?>/assets/img/service/service-1.jpg" alt="service">
							</a>
							<span class="service-icon">
								<i class="flaticon-lemon"></i>
							</span>
						</div>
						<div class="service-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?service=fresh-organic">Fresh Organic</a></h4>
							<p>
								Sedut perspicis unde omne iste natus error sit voluptatem acntium doloremque laudanum
								totam
							</p>
							<a href="<?php echo esc_url(home_url('/')); ?>?service=fresh-organic" class="read-more"><i class="far fa-long-arrow-right"></i></a>
						</div>
					</div>
				</div>
				<div class="col-xl-4 col-md-6">
					<div class="service-wrap-2">
						<div class="service-thumb">
							<a href="<?php echo esc_url(home_url('/')); ?>?service=fruits-care">
								<img src="<?php echo get_template_directory_uri();?>/assets/img/service/service-2.jpg" alt="service">
							</a>
							<span class="service-icon">
								<i class="flaticon-onion"></i>
							</span>
						</div>
						<div class="service-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?service=fruits-care">Fruits Care</a></h4>
							<p>
								Sedut perspicis unde omne iste natus error sit voluptatem acntium doloremque laudanum
								totam
							</p>
							<a href="<?php echo esc_url(home_url('/')); ?>?service=fruits-care" class="read-more"><i class="far fa-long-arrow-right"></i></a>
						</div>
					</div>
				</div>
				<div class="col-xl-4 col-md-6">
					<div class="service-wrap-2">
						<div class="service-thumb">
							<a href="<?php echo esc_url(home_url('/')); ?>?service=organic-vegetables">
								<img src="<?php echo get_template_directory_uri();?>/assets/img/service/service-3.jpg" alt="service">
							</a>
							<span class="service-icon">
								<i class="flaticon-tomato"></i>
							</span>
						</div>
						<div class="service-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?service=organic-vegetables">Vegetables</a></h4>
							<p>
								Sedut perspicis unde omne iste natus error sit voluptatem acntium doloremque laudanum
								totam
							</p>
							<a href="<?php echo esc_url(home_url('/')); ?>?service=organic-vegetables" class="read-more"><i class="far fa-long-arrow-right"></i></a>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="shape-1">
			<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-6.png" alt="icon">
		</div>
		<div class="shape-2">
			<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-7.png" alt="icon">
		</div>
	</div>
	<!--    service-area end    -->


	<!--    cta-area start    -->
	<div class="cta-area" style="background-image: url(<?php echo get_template_directory_uri();?>/assets/img/bg/cta-bg.jpg)">
		<div class="container">
			<div class="row justify-content-end">
				<div class="col-xl-7 col-lg-9">
					<div class="cta-text">
						<div class="cta-cat">
							<a href="#" tabindex="0">Free Consultations</a>
						</div>
						<div class="cta-content">
							<h4>Food Is Very Important Every For Human Beings</h4>
							<p>
								with love & dedication
							</p>
						</div>
						<div class="cta-btn">
							<a href="https://www.youtube.com/watch?v=oF5y2uLFoX0" class="play-btn popup-video">
								<span>watch videos</span>
								<i class="far fa-play"></i>
							</a>
							<a href="<?php echo esc_url(home_url('/')); ?>?page_id=67" class="a-btn" tabindex="0">get a quote <i class="fas fa-plus"></i></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--    cta-area end    -->

	<!--    choose-us-area start    -->
	<div class="choose-us-area">
		<div class="choose-us-bg" style="background-image: url(<?php echo get_template_directory_uri();?>/assets/img/bg/choose-us-bg.png)">
			<div class="container">
				<div class="row">
					<div class="col-xl-6 col-lg-6">
						<div class="choose-us-wrap">
							<div class="section-title section-title-white mb-20">
								<h5>Why Choose Us</h5>
								<h3>Special Support & Caring Organic Farm Agency</h3>
								<div class="icon">
									<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-5-white.png" alt="icon">
								</div>
							</div>
							<p>
								Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque
								laudantium, totam rem aperiaceaque ipsa quae ab illo inventore veritatis et quasi
								architecto beataest vitae dicta sunt explicabo enim ipsam voluptatem
							</p>
							<a href="<?php echo esc_url(home_url('/')); ?>?page_id=60" class="b-btn">
								Learn more
								<i class="fas fa-plus"></i>
							</a>
						</div>
					</div>
					<div class="col-xl-5 offset-xl-1 col-lg-6 mt-md-50 mt-xs-50 align-self-center">
						<div class="choose-us-list mb-35">
							<div class="choose-list-icon">
								<div class="icon">
									<i class="far fa-leaf"></i>
								</div>
							</div>
							<div class="choose-list-details">
								<h4>Natural Process</h4>
								<p>Sorem ipsum dolor sit amet consecta dipisicing sed eiusmod tempor</p>
							</div>
						</div>
						<div class="choose-us-list mb-35">
							<div class="choose-list-icon">
								<div class="icon">
									<i class="far fa-leaf"></i>
								</div>
							</div>
							<div class="choose-list-details">
								<h4>Fresh & Organic Product</h4>
								<p>Quis autem vel eum iure reprehenderit qui nea voluptate velit esse quam</p>
							</div>
						</div>
						<div class="choose-us-list">
							<div class="choose-list-icon">
								<div class="icon">
									<i class="far fa-leaf"></i>
								</div>
							</div>
							<div class="choose-list-details">
								<h4>Homegrown Goodness</h4>
								<p>To take a trivial example, which of ever undertakes laborious physical</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--    choose-us-area end    -->

	<!--    photo-gallery-area start    -->
	<div class="photo-gallery-area gallery-filter-wrapper pt-130 pb-100">
		<div class="container">
			<div class="row justify-content-center mb-20">
				<div class="col-xl-6 col-lg-8 col-md-10">
					<div class="section-title text-center">
						<h5>Photo Gallery</h5>
						<h3>Let’s See Our Beautyful Gardern Views</h3>
						<div class="icon">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-5.png" alt="icon">
						</div>
					</div>
				</div>
			</div>
			<div class="row mb-60">
				<div class="col-xl-12">
					<div class="gallery-filter-nav">
						<button class="active" data-filter="*">Show All</button>
						<button data-filter=".vegetables">Vegetables</button>
						<button data-filter=".farmers">Farmers</button>
						<button data-filter=".doctors">Doctors</button>
						<button data-filter=".fruits">Fruits</button>
						<button data-filter=".gardern">Gardern</button>
					</div>
				</div>
			</div>
		</div>
		<div class="container-fluid gallery-filter-space">
			<div class="row gallery-filter-grid">
				<div class="col-xl-3 col-md-6 grid-item vegetables gardern">
					<div class="photo-gallery-wrap mb-30">
						<div class="gallery-thumb">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/gallery/gallery-1.jpg" alt="gallery">
						</div>
						<div class="gallery-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?gallery=103-2">Natural Fresh Strawberry</a></h4>
							<span class="cat"><a href="<?php echo esc_url(home_url('/')); ?>?gallery=103-2">Fresh Food</a></span>
							<a href="<?php echo esc_url(home_url('/')); ?>?gallery=103-2" class="read-more"><i class="far fa-long-arrow-right"></i></a>
						</div>
					</div>
				</div>
				<div class="col-xl-3 col-md-6 grid-item farmers fruits">
					<div class="photo-gallery-wrap mb-30">
						<div class="gallery-thumb">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/gallery/gallery-2.jpg" alt="gallery">
						</div>
						<div class="gallery-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?gallery=orange-tomato-2">Orange Tomato</a></h4>
							<span class="cat"><a href="<?php echo esc_url(home_url('/')); ?>?gallery=orange-tomato-2">Fresh Food</a></span>
							<a href="<?php echo esc_url(home_url('/')); ?>?gallery=orange-tomato-2" class="read-more"><i class="far fa-long-arrow-right"></i></a>
						</div>
					</div>
				</div>
				<div class="col-xl-3 col-md-6 grid-item doctors farmers">
					<div class="photo-gallery-wrap mb-30">
						<div class="gallery-thumb">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/gallery/gallery-3.jpg" alt="gallery">
						</div>
						<div class="gallery-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?gallery=fresh-strawberry-2">Fresh Strawberry</a></h4>
							<span class="cat"><a href="<?php echo esc_url(home_url('/')); ?>?gallery=fresh-strawberry-2">Fresh Food</a></span>
							<a href="<?php echo esc_url(home_url('/')); ?>?gallery=fresh-strawberry-2" class="read-more"><i class="far fa-long-arrow-right"></i></a>
						</div>
					</div>
				</div>
				<div class="col-xl-3 col-md-6 grid-item fruits gardern">
					<div class="photo-gallery-wrap mb-30">
						<div class="gallery-thumb">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/gallery/gallery-4.jpg" alt="gallery">
						</div>
						<div class="gallery-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?gallery=fresh-orange">Fresh Orange</a></h4>
							<span class="cat"><a href="<?php echo esc_url(home_url('/')); ?>?gallery=fresh-orange">Fresh Food</a></span>
							<a href="<?php echo esc_url(home_url('/')); ?>?gallery=fresh-orange" class="read-more"><i class="far fa-long-arrow-right"></i></a>
						</div>
					</div>
				</div>
				<div class="col-xl-6 col-md-6 grid-item gardern doctors">
					<div class="photo-gallery-wrap mb-30">
						<div class="gallery-thumb">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/gallery/gallery-5.jpg" alt="gallery">
						</div>
						<div class="gallery-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?gallery=orange-tomato">Orange Tomato</a></h4>
							<span class="cat"><a href="<?php echo esc_url(home_url('/')); ?>?gallery=orange-tomato">Fresh Food</a></span>
							<a href="<?php echo esc_url(home_url('/')); ?>?gallery=orange-tomato" class="read-more"><i class="far fa-long-arrow-right"></i></a>
						</div>
					</div>
				</div>
				<div class="col-xl-3 col-md-6 grid-item vegetables fruits">
					<div class="photo-gallery-wrap mb-30">
						<div class="gallery-thumb">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/gallery/gallery-6.jpg" alt="gallery">
						</div>
						<div class="gallery-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?gallery=fresh-strawberry">Fresh Strawberry</a></h4>
							<span class="cat"><a href="<?php echo esc_url(home_url('/')); ?>?gallery=fresh-strawberry">Fresh Food</a></span>
							<a href="<?php echo esc_url(home_url('/')); ?>?gallery=fresh-strawberry" class="read-more"><i class="far fa-long-arrow-right"></i></a>
						</div>
					</div>
				</div>
				<div class="col-xl-3 col-md-6 grid-item farmers gardern">
					<div class="photo-gallery-wrap mb-30">
						<div class="gallery-thumb">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/gallery/gallery-7.jpg" alt="gallery">
						</div>
						<div class="gallery-details">
							<h4><a href="<?php echo esc_url(home_url('/')); ?>?gallery=organic-vegetables">Fresh Orange</a></h4>
							<span class="cat"><a href="<?php echo esc_url(home_url('/')); ?>?gallery=organic-vegetables">Fresh Food</a></span>
							<a href="<?php echo esc_url(home_url('/')); ?>?gallery=organic-vegetables" class="read-more"><i class="far fa-long-arrow-right"></i></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--    photo-gallery-area end    -->

	<!--    team-area start    -->
	<div class="team-area pb-130">
		<div class="container">
			<div class="row justify-content-center mb-50">
				<div class="col-xl-6 col-lg-8 col-md-10">
					<div class="section-title text-center">
						<h5>Team Members</h5>
						<h3>Meet Our Expert Team Members</h3>
						<div class="icon">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-5.png" alt="icon">
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xl-12">
					<div class="team-slider">
						<div class="team-slide">
							<div class="team-wrap">
								<div class="team-thumb">
									<a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">
										<img src="<?php echo get_template_directory_uri();?>/assets/img/team/team-1.jpg" alt="team">
									</a>
								</div>
								<div class="team-details">
									<h4><a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">Benjamin R. Preece</a></h4>
									<p>Organic Farmer</p>
									<div class="social">
										<a href="https://www.facebook.com/" class="facebook"><i class="fab fa-facebook-f"></i></a>
										<a href="https://twitter.com/" class="twitter"><i class="fab fa-twitter"></i></a>
										<a href="https://www.pinterest.com/" class="pinterest"><i class="fab fa-pinterest-p"></i></a>
										<a href="https://www.instagram.com/" class="instagram"><i class="fab fa-instagram"></i></a>
									</div>
								</div>
							</div>
						</div>
						<div class="team-slide">
							<div class="team-wrap">
								<div class="team-thumb">
									<a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">
										<img src="<?php echo get_template_directory_uri();?>/assets/img/team/team-4.jpg" alt="team">
									</a>
								</div>
								<div class="team-details">
									<h4><a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">Donald L. Alexander</a></h4>
									<p>Organic Farmer</p>
									<div class="social">
										<a href="https://www.facebook.com/" class="facebook"><i class="fab fa-facebook-f"></i></a>
										<a href="https://twitter.com/" class="twitter"><i class="fab fa-twitter"></i></a>
										<a href="https://www.pinterest.com/" class="pinterest"><i class="fab fa-pinterest-p"></i></a>
										<a href="https://www.instagram.com/" class="instagram"><i class="fab fa-instagram"></i></a>
									</div>
								</div>
							</div>
						</div>
						<div class="team-slide">
							<div class="team-wrap">
								<div class="team-thumb">
									<a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">
										<img src="<?php echo get_template_directory_uri();?>/assets/img/team/team-2.jpg" alt="team">
									</a>
								</div>
								<div class="team-details">
									<h4><a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">Andrew J. Cousins</a></h4>
									<p>Organic Farmer</p>
									<div class="social">
										<a href="https://www.facebook.com/" class="facebook"><i class="fab fa-facebook-f"></i></a>
										<a href="https://twitter.com/" class="twitter"><i class="fab fa-twitter"></i></a>
										<a href="https://www.pinterest.com/" class="pinterest"><i class="fab fa-pinterest-p"></i></a>
										<a href="https://www.instagram.com/" class="instagram"><i class="fab fa-instagram"></i></a>
									</div>
								</div>
							</div>
						</div>
						<div class="team-slide">
							<div class="team-wrap">
								<div class="team-thumb">
									<a href="<?php echo esc_url(home_url('/')); ?>?page_id=62"><img src="<?php echo get_template_directory_uri();?>/assets/img/team/team-3.jpg" alt="team"></a>
								</div>
								<div class="team-details">
									<h4><a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">Bernard M. Richardson</a></h4>
									<p>Organic Farmer</p>
									<div class="social">
										<a href="https://www.facebook.com/" class="facebook"><i class="fab fa-facebook-f"></i></a>
										<a href="https://twitter.com/" class="twitter"><i class="fab fa-twitter"></i></a>
										<a href="https://www.pinterest.com/" class="pinterest"><i class="fab fa-pinterest-p"></i></a>
										<a href="https://www.instagram.com/" class="instagram"><i class="fab fa-instagram"></i></a>
									</div>
								</div>
							</div>
						</div>
						<div class="team-slide">
							<div class="team-wrap">
								<div class="team-thumb">
									<a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">
										<img src="<?php echo get_template_directory_uri();?>/assets/img/team/team-1.jpg" alt="team">
									</a>
								</div>
								<div class="team-details">
									<h4><a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">Benjamin R. Preece</a></h4>
									<p>Organic Farmer</p>
									<div class="social">
										<a href="https://www.facebook.com/" class="facebook"><i class="fab fa-facebook-f"></i></a>
										<a href="https://twitter.com/" class="twitter"><i class="fab fa-twitter"></i></a>
										<a href="https://www.pinterest.com/" class="pinterest"><i class="fab fa-pinterest-p"></i></a>
										<a href="https://www.instagram.com/" class="instagram"><i class="fab fa-instagram"></i></a>
									</div>
								</div>
							</div>
						</div>
						<div class="team-slide">
							<div class="team-wrap">
								<div class="team-thumb">
									<a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">
										<img src="<?php echo get_template_directory_uri();?>/assets/img/team/team-5.jpg" alt="team">
									</a>
								</div>
								<div class="team-details">
									<h4><a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">Donald L. Alexander</a></h4>
									<p>Organic Farmer</p>
									<div class="social">
										<a href="https://www.facebook.com/" class="facebook"><i class="fab fa-facebook-f"></i></a>
										<a href="https://twitter.com/" class="twitter"><i class="fab fa-twitter"></i></a>
										<a href="https://www.pinterest.com/" class="pinterest"><i class="fab fa-pinterest-p"></i></a>
										<a href="https://www.instagram.com/" class="instagram"><i class="fab fa-instagram"></i></a>
									</div>
								</div>
							</div>
						</div>
						<div class="team-slide">
							<div class="team-wrap">
								<div class="team-thumb">
									<a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">
										<img src="<?php echo get_template_directory_uri();?>/assets/img/team/team-7.jpg" alt="team">
									</a>
								</div>
								<div class="team-details">
									<h4><a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">Andrew J. Cousins</a></h4>
									<p>Organic Farmer</p>
									<div class="social">
										<a href="https://www.facebook.com/" class="facebook"><i class="fab fa-facebook-f"></i></a>
										<a href="https://twitter.com/" class="twitter"><i class="fab fa-twitter"></i></a>
										<a href="https://www.pinterest.com/" class="pinterest"><i class="fab fa-pinterest-p"></i></a>
										<a href="https://www.instagram.com/" class="instagram"><i class="fab fa-instagram"></i></a>
									</div>
								</div>
							</div>
						</div>
						<div class="team-slide">
							<div class="team-wrap">
								<div class="team-thumb">
									<a href="<?php echo esc_url(home_url('/')); ?>?page_id=62"><img src="<?php echo get_template_directory_uri();?>/assets/img/team/team-8.jpg" alt="team"></a>
								</div>
								<div class="team-details">
									<h4><a href="<?php echo esc_url(home_url('/')); ?>?page_id=62">Bernard M. Richardson</a></h4>
									<p>Organic Farmer</p>
									<div class="social">
										<a href="https://www.facebook.com/" class="facebook"><i class="fab fa-facebook-f"></i></a>
										<a href="https://twitter.com/" class="twitter"><i class="fab fa-twitter"></i></a>
										<a href="https://www.pinterest.com/" class="pinterest"><i class="fab fa-pinterest-p"></i></a>
										<a href="https://www.instagram.com/" class="instagram"><i class="fab fa-instagram"></i></a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--    team-area end    -->

	<!--    counter-area start    -->
	<div class="counter-area bg-fix" style="background-image: url(<?php echo get_template_directory_uri();?>/assets/img/bg/counter-bg.jpg)">
		<div class="container">
			<div class="row justify-content-center align-items-center">
				<div class="col-xl-5 col-lg-6 col-md-8">
					<div class="counter-details text-center">
						<a href="https://www.youtube.com/watch?v=oF5y2uLFoX0" class="play-animation popup-video">
							<i class="fas fa-play"></i>
							<span class="shape"></span>
						</a>
						<h3>How To Serve Gardern Watch Videos</h3>
					</div>
				</div>
				<div class="col-xl-7">
					<div class="counter-right-wrap">
						<h4>We Are Startup Company. Experts In Field Organic Startup Movement.</h4>
						<div class="row">
							<div class="col-xl-6 col-md-6">
								<div class="counter-wrap mb-60">
									<span class="icon">
										<i class="fas fa-umbrella-beach"></i>
									</span>
									<h4><span>25</span>+</h4>
									<p>Years Experience</p>
								</div>
							</div>
							<div class="col-xl-6 col-md-6">
								<div class="counter-wrap mb-60">
									<span class="icon">
										<i class="far fa-users-crown"></i>
									</span>
									<h4><span>97</span>+</h4>
									<p>Expert Member</p>
								</div>
							</div>
							<div class="col-xl-6 col-md-6">
								<div class="counter-wrap mb-60">
									<span class="icon">
										<i class="far fa-trophy-alt"></i>
									</span>
									<h4><span>3</span>k+</h4>
									<p>Awards Wins</p>
								</div>
							</div>
							<div class="col-xl-6 col-md-6">
								<div class="counter-wrap mb-60">
									<span class="icon">
										<i class="far fa-trees"></i>
									</span>
									<h4><span>65</span>+</h4>
									<p>Global Branch</p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--    counter-area end    -->

	<!--    testimonial-area start    -->
	<div class="testimonial-area pt-130 pb-130">
		<div class="container">
			<div class="row justify-content-center mb-50">
				<div class="col-xl-5 col-lg-6 col-md-10">
					<div class="section-title text-center">
						<h5>Company Reviews</h5>
						<h3>What Loving People Say About us</h3>
						<div class="icon">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-5.png" alt="icon">
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xl-12">
					<div class="testimonial-slider">
						<div class="testimonial-slide">
							<div class="row justify-content-center align-items-center">
								<div class="col-xl-4 col-lg-4 d-none d-xl-block d-lg-block">
									<div class="testimonial-img">
										<img src="<?php echo get_template_directory_uri();?>/assets/img/thumb/author-lg.png" alt="author">
									</div>
								</div>
								<div class="col-xl-6 col-lg-8 col-md-10">
									<div class="testimonial-details">
										<div class="rating">
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
										</div>
										<p>
											Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium
											oloremque laudantium totam rem aperiam eaque ipsa quae inventore veritatis
											architecto
										</p>
										<div class="author-wrap">
											<div class="author-thumb">
												<img src="<?php echo get_template_directory_uri();?>/assets/img/thumb/author-1.jpg" alt="author">
											</div>
											<div class="author-text">
												<h5>Sileen P. Willilams</h5>
												<p>Web Designer</p>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="testimonial-slide">
							<div class="row justify-content-center align-items-center">
								<div class="col-xl-4 col-lg-4 d-none d-xl-block d-lg-block">
									<div class="testimonial-img">
										<img src="<?php echo get_template_directory_uri();?>/assets/img/thumb/author-lg.png" alt="author">
									</div>
								</div>
								<div class="col-xl-6 col-lg-8 col-md-10">
									<div class="testimonial-details">
										<div class="rating">
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
										</div>
										<p>
											Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium
											oloremque laudantium totam rem aperiam eaque ipsa quae inventore veritatis
											architecto
										</p>
										<div class="author-wrap">
											<div class="author-thumb">
												<img src="<?php echo get_template_directory_uri();?>/assets/img/thumb/author-1.jpg" alt="author">
											</div>
											<div class="author-text">
												<h5>Sileen P. Willilams</h5>
												<p>Web Designer</p>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="testimonial-slide">
							<div class="row justify-content-center align-items-center">
								<div class="col-xl-4 col-lg-4 d-none d-xl-block d-lg-block">
									<div class="testimonial-img">
										<img src="<?php echo get_template_directory_uri();?>/assets/img/thumb/author-lg.png" alt="author">
									</div>
								</div>
								<div class="col-xl-6 col-lg-8 col-md-10">
									<div class="testimonial-details">
										<div class="rating">
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
										</div>
										<p>
											Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium
											oloremque laudantium totam rem aperiam eaque ipsa quae inventore veritatis
											architecto
										</p>
										<div class="author-wrap">
											<div class="author-thumb">
												<img src="<?php echo get_template_directory_uri();?>/assets/img/thumb/author-1.jpg" alt="author">
											</div>
											<div class="author-text">
												<h5>Sileen P. Willilams</h5>
												<p>Web Designer</p>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--    testimonial-area end    -->

	<!--    blog-area start    -->
	<div class="blog-area pt-130 pb-100 bg-fix" style="background-image: url(<?php echo get_template_directory_uri();?>/assets/img/bg/map-bg.png)">
		<div class="container">
			<div class="row justify-content-center mb-50">
				<div class="col-xl-5 col-lg-6 col-md-10">
					<div class="section-title text-center">
						<h5>Articles & Tips</h5>
						<h3>Let’s Read Our Latest News & Blog</h3>
						<div class="icon">
							<img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-5.png" alt="icon">
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<?php 
				$args = array(   
					'post_type' => 'post', 
				);  
				$wp_query = new WP_Query($args);
				while ($wp_query -> have_posts()) : $wp_query -> the_post();    
					?>  
					<div class="col-xl-4 col-lg-6">
						<div class="blog-box-wrap">
							<div class="blog-box-thumb">
								<a href="<?php the_permalink();?>">
									<img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="blog">
								</a>
							</div>
							<div class="blog-box-details">
								<h4>
									<a href="<?php the_permalink();?>"><?php the_title();?></a>
								</h4>
								<p>
                                <?php if(isset($fudee_redux_demo['blog_excerpt'])){?>
                                    <?php echo esc_attr(fudee_excerpt2($fudee_redux_demo['blog_excerpt'])); ?>
                                    <?php }else{?>
                                    <?php echo esc_attr(fudee_excerpt2(12)); 
                                    }?>
                            	</p>
								<a href="<?php the_permalink();?>" class="read-more"><?php if(isset($fudee_redux_demo['read_more'])){?>
									<?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['read_more']));?>
								<?php }else{?>
									<?php echo esc_html__( 'Read more', 'fudee' );
								}
								?> <i class="far fa-angle-right"></i></a>
							</div>
						</div>
					</div>
				<?php endwhile; ?>
			</div>
		</div>
	</div>

<?php get_footer(); ?>