<?php

/**

 * The Template for displaying all single posts

 */

$fudee_redux_demo = get_option('redux_demo');

get_header(); ?>



<?php 

    while (have_posts()): the_post();

    $countdown_title = get_post_meta(get_the_ID(),'_cmb_countdown_title', true);

?>  



<?php if(isset($fudee_redux_demo['gallery_image']['url']) && $fudee_redux_demo['gallery_image']['url'] != ''){?>

<section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo esc_url($fudee_redux_demo['gallery_image']['url']);?>)">

<?php }else{?>  

<section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo (get_template_directory_uri().'/assets/img/bg/breadcrumb-bg.jpg');?>)">

<?php } ?> 

        <div class="container">

            <div class="row justify-content-center">

                <div class="col-lg-8 text-center">

                    <div class="breadcrumb-content">

                        <h3 class="title"><?php if(isset($fudee_redux_demo['gallery_details_title']) && $fudee_redux_demo['gallery_details_title'] != ''){?>

                    <?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['gallery_details_title']));?>

                    <?php }else{?>

                    <?php echo esc_html__( 'Gallery Details', 'fudee' );

                    }

                    ?></h3>

                        <ul>

                            <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__( 'Home', 'fudee' );?></a></li>

                            <li class="active"><?php if(isset($fudee_redux_demo['gallery_details_title']) && $fudee_redux_demo['gallery_details_title'] != ''){?>

                    <?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['gallery_details_title']));?>

                    <?php }else{?>

                    <?php echo esc_html__( 'Gallery Details', 'fudee' );

                    }

                    ?></li>

                        </ul>

                    </div>

                </div>

            </div>

        </div>

    </section>

    <!--    breadcrumb-area end    -->



    <!--    gallery-area start    -->

    <div class="gallery-area pt-100 pb-80">

        <div class="container">

            <div class="row">

                <div class="col-xl-12">

                    <div class="gallery-single-wrap">

                        <div class="gallery-wrap-img">

                            <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="thumb">

                        </div>

                        <?php the_content(); ?>

                        <?php wp_link_pages(); ?>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <!--    gallery-area end    -->



    <!--    gallery-area start    -->

    <div class="gallery-area pb-80">

        <div class="container">

            <div class="row justify-content-center mb-55">

                <div class="col-xl-6 col-lg-8 col-md-10">

                    <div class="section-title text-center">

                        <h5>Releted Project</h5>

                        <h3>We Provide Different Organic Healthy Foods</h3>

                        <div class="icon">

                            <img src="<?php echo (get_template_directory_uri().'/assets/img/icon/icon-5.png');?>" alt="icon">

                        </div>

                    </div>

                </div>

            </div>

        <?php endwhile; ?>

            <div class="row">

                 <?php 

               $args = array(   

                'post_type' => 'gallery',

                'paged' => $paged,

                'posts_per_page' => 3,

                'order' => ASC,

                'orderby' => $orderby, 

                );  

               $wp_query = new WP_Query($args);

               $i = 0;

               while ($wp_query -> have_posts()) : $wp_query -> the_post();

                $gallery_image = get_post_meta(get_the_ID(),'_cmb_gallery_image', true);

                $gallery_type = get_post_meta(get_the_ID(),'_cmb_gallery_type', true);

                ?>

                <div class="col-xl-4 col-lg-4 col-md-6">

                    <div class="gallery-wrapper mb-30">

                        <div class="gallery-img">

                            <a href="#"><img src="<?php echo wp_get_attachment_url($gallery_image); ?>" alt=""></a>

                            <div class="gallery-icon">

                                <a href="<?php echo wp_get_attachment_url($gallery_image); ?>" class="popup-image"><i class="far fa-plus"></i></a>

                            </div>

                        </div>

                        <div class="gallery-text text-center">

                            <h3><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h3>

                            <span><?php echo esc_attr($gallery_type); ?></span>

                        </div>

                    </div>

                </div>

                <?php endwhile; ?>

            </div>

        </div>

    </div>

    <!--    gallery-area end    -->



<?php

get_footer();

?>