<?php

/**

 * The Template for displaying all single posts

 */

$fudee_redux_demo = get_option('redux_demo');

get_header(); ?>



<?php 

    while (have_posts()): the_post();

?>  



<?php if(isset($fudee_redux_demo['service_image']['url']) && $fudee_redux_demo['service_image']['url'] != ''){?>

    <section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo esc_url($fudee_redux_demo['service_image']['url']);?>)">

<?php }else{?>    

    <section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo (get_template_directory_uri().'/assets/img/bg/breadcrumb-bg.jpg');?>)">

<?php } ?> 

    <div class="container">

        <div class="row justify-content-center">

            <div class="col-lg-8 text-center">

                <div class="breadcrumb-content">

                    <h3 class="title"><?php the_title();?></h3>

                </div>

            </div>

        </div>

    </div>

</section>

    <!--    breadcrumb-area end    -->



    <!--    service-area start    -->

    <div class="service-area pt-130 pb-100">

        <div class="container">

            <div class="row justify-content-center">

                <div class="col-xl-8 col-lg-8">

                    <div class="services-details-wrapper">

                        <div class="services-details-img mb-30">

                            <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="thumb">

                        </div>

                        <?php the_content(); ?>

                        <?php wp_link_pages(); ?>

                    </div>

                </div>

                <div class="col-xl-4 col-lg-4 col-md-8">

                    <div class="service-sidebar">

                        <?php get_sidebar('service');?>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <!--    service-area end    -->



    <!--    service-area start    -->

    <div class="service-area service-area-2 pt-100 pb-100" style="background-image: url(<?php echo get_template_directory_uri();?>/assets/img/shape/shape-1.png)">

        <div class="container">

            <div class="row justify-content-center mb-55">

                <div class="col-xl-6 col-lg-8 col-md-10">

                    <div class="section-title text-center">

                        <h5>What We Do</h5>

                        <h3>Services We Provide That Benifited Health</h3>

                        <div class="icon">

                            <img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-5.png" alt="icon">

                        </div>

                    </div>

                </div>

            </div>

        <?php endwhile; ?>

            <div class="row">

               <?php 

               $args = array(   

                'post_type' => 'service',

                'paged' => $paged,

                'posts_per_page' => 3,

                'order' => ASC,

                'orderby' => $orderby, 

                );  

               $wp_query = new WP_Query($args);

               $i = 0;

               while ($wp_query -> have_posts()) : $wp_query -> the_post();

                $service_icon = get_post_meta(get_the_ID(),'_cmb_service_icon', true);

                $service_excerpt = get_post_meta(get_the_ID(),'_cmb_service_excerpt', true);

                ?>

                <div class="col-xl-4 col-md-6">

                    <div class="service-wrap-2">

                        <div class="service-thumb">

                            <a href="<?php the_permalink();?>">

                                <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="service">

                            </a>

                            <span class="service-icon">

                                <i class="<?php echo esc_attr($service_icon); ?>"></i>

                            </span>

                        </div>

                        <div class="service-details">

                            <h4><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h4>

                            <p>

                                <?php echo esc_attr($service_excerpt);?>

                            </p>

                            <a href="<?php the_permalink();?>" class="read-more"><i class="far fa-long-arrow-right"></i></a>

                        </div>

                    </div>

                </div>

                <?php endwhile; ?>

            </div>

        </div>

        <div class="shape-1">

            <img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-6.png" alt="icon">

        </div>

        <div class="shape-2">

            <img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-7.png" alt="icon">

        </div>

    </div>

    <!--    service-area end    -->



    <!--    choose-us-area start    -->

    <div class="choose-area-2 pt-130 pb-100" style="background-image: url(<?php echo get_template_directory_uri();?>/assets/img/bg/choose-us-bg.png)">

        <div class="container">

            <div class="row justify-content-center align-items-center">

                <div class="col-xl-5 col-lg-6 col-md-8 col-10">

                    <div class="choose-us-thumb">

                        <img src="<?php echo get_template_directory_uri();?>/assets/img/thumb/thumb-9.jpg" alt="thumb">

                    </div>

                </div>

                <div class="col-xl-5 offset-xl-1 col-lg-6 mt-md-50 mt-xs-50 align-self-center">

                    <div class="section-title mb-35">

                        <h5>Why Choose Us</h5>

                        <h3>Special Support & Caring Organic Farm</h3>

                        <div class="icon">

                            <img src="<?php echo get_template_directory_uri();?>/assets/img/icon/icon-5.png" alt="icon">

                        </div>

                    </div>

                    <div class="choose-us-list-2 mb-35">

                        <div class="choose-list-icon">

                            <div class="icon">

                                <i class="far fa-leaf"></i>

                            </div>

                        </div>

                        <div class="choose-list-details">

                            <h4>Natural Process</h4>

                            <p>Sorem ipsum dolor sit amet consecta dipisicing sed eiusmod tempor</p>

                        </div>

                    </div>

                    <div class="choose-us-list-2 mb-35">

                        <div class="choose-list-icon">

                            <div class="icon">

                                <i class="far fa-leaf"></i>

                            </div>

                        </div>

                        <div class="choose-list-details">

                            <h4>Fresh &amp; Organic Product</h4>

                            <p>Quis autem vel eum iure reprehenderit qui nea voluptate velit esse quam</p>

                        </div>

                    </div>

                    <div class="choose-us-list-2 mb-35">

                        <div class="choose-list-icon">

                            <div class="icon">

                                <i class="far fa-leaf"></i>

                            </div>

                        </div>

                        <div class="choose-list-details">

                            <h4>Homegrown Goodness</h4>

                            <p>To take a trivial example, which of ever undertakes laborious physical</p>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>





<?php

get_footer();

?>