<?php
/**
 * The Template for displaying all single posts
 */
$fudee_redux_demo = get_option('redux_demo');
get_header(); ?>

<?php 
    while (have_posts()): the_post();
    $single_facebook = get_post_meta(get_the_ID(),'_cmb_single_facebook', true);
    $single_twitter = get_post_meta(get_the_ID(),'_cmb_single_twitter', true);
    $single_behance = get_post_meta(get_the_ID(),'_cmb_single_behance', true);
    $single_youtube = get_post_meta(get_the_ID(),'_cmb_single_youtube', true);
    $single_vimeo = get_post_meta(get_the_ID(),'_cmb_single_vimeo', true);
?>

<?php if(isset($fudee_redux_demo['blog_image']['url']) && $fudee_redux_demo['blog_image']['url'] != ''){?>
    <section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo esc_url($fudee_redux_demo['blog_image']['url']);?>)">
<?php }else{?>    
    <section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo (get_template_directory_uri().'/assets/img/bg/breadcrumb-bg.jpg');?>)">
<?php } ?>   
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                    <div class="breadcrumb-content">
                        <h3 class="title"><?php the_title();?></h3>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--    breadcrumb-area end    -->

    <!--    about-area start    -->
    <div class="blog-grid-area pt-130 pb-100">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8">
                    <article class="blog-single-wrap mb-40">
                        <?php if ( has_post_thumbnail() ) { ?>
                        <div class="blog-wrap-thumb">
                            <a href="<?php the_permalink();?>">
                                <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="blog">
                            </a>
                        </div>
                        <?php } ?>
                        <div class="blog-wrap-details">
                            <div class="blog-wrap-meta mb-15">
                                <span><i class="far fa-calendar-check"></i> <?php the_time(get_option( 'date_format'));?> </span>
                                <span><i class="far fa-user"></i> <?php the_author_posts_link(); ?></span>
                                <span><i class="far fa-comments"></i> <?php comments_number( esc_html__('0 Comments', 'fudee'), esc_html__('1 Comment', 'fudee'), esc_html__('% Comments', 'fudee')); ?></span>
                            </div>
                            <div class="blog-wrap-text">
                                <?php the_content(); ?>
                                <?php wp_link_pages(); ?>
                                <div class="row mt-50">
                                    <div class="col-xl-8 col-lg-8 col-md-8">
                                        <div class="blog-post-tag">
                                            <span><?php echo esc_html__( 'Tags', 'fudee' );?></span>
                                            <?php echo get_the_tag_list(); ?>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 col-lg-4 col-md-4">
                                        <div class="blog-share-icon text-left text-md-right">
                                            <span><?php echo esc_html__( 'Share: ', 'fudee' );?></span>
                                            <a href="<?php echo esc_url($single_facebook); ?>"><i class="fab fa-facebook-f"></i></a>
                                            <a href="<?php echo esc_url($single_twitter); ?>"><i class="fab fa-twitter"></i></a>
                                            <a href="<?php echo esc_url($single_instagram); ?>"><i class="fab fa-instagram"></i></a>
                                            <a href="<?php echo esc_url($single_google); ?>"><i class="fab fa-google-plus-g"></i></a>
                                            <a href="<?php echo esc_url($single_vimeo); ?>"><i class="fab fa-vimeo-v"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php comments_template();?>
                    </article>
                </div>
                <div class="col-xl-4 col-lg-4 col-md-10">
                    <div class="blog-sidebar">
                        <?php get_sidebar();?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--    about-area end    -->
<?php endwhile; ?>

<?php
get_footer();
?>