<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header();


?>

<?php if(isset($fudee_redux_demo['blog_image']['url']) && $fudee_redux_demo['blog_image']['url'] != ''){?>
    <section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo esc_url($fudee_redux_demo['blog_image']['url']);?>)">
<?php }else{?>    
    <section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo (get_template_directory_uri().'/assets/img/bg/breadcrumb-bg.jpg');?>)">
<?php } ?>   
<div class="container">
	<div class="row justify-content-center">
		<div class="col-lg-8 text-center">
			<div class="breadcrumb-content">
				<?php if(isset($fudee_redux_demo['shop_title']) && $fudee_redux_demo['shop_title'] != ''){?>
					<h3 class="title"><?php echo esc_attr($fudee_redux_demo['shop_title']);?></h3>
				<?php }else{ ?>
					<h3 class="title"><?php echo esc_html__( 'Shop', 'fudee' )?></h3>
				<?php } ?>
				<ul>
					<li><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__( 'Home', 'fudee' )?></a></li>
					<?php if(isset($fudee_redux_demo['shop_title']) && $fudee_redux_demo['shop_title'] != ''){?>
					<li class="active"><?php echo esc_attr($fudee_redux_demo['shop_title']);?></li>
					<?php }else{ ?>
					<li class="active"><?php echo esc_html__( 'Shop', 'fudee' )?></li>
					<?php } ?>
				</ul>
			</div>
		</div>
	</div>
</div>
</section>

<div class="product-area pt-130 pb-130">
		<div class="container">
			<div class="row">
				<?php
            	if ( woocommerce_product_loop() ) {

				/**
				 * Hook: woocommerce_before_shop_loop.
				 *
				 * @hooked woocommerce_output_all_notices - 10
				 * @hooked woocommerce_result_count - 20
				 * @hooked woocommerce_catalog_ordering - 30
				 */
				do_action( 'woocommerce_before_shop_loop' );
				?>
			</div>

			<?php
			woocommerce_product_loop_start();

			if ( wc_get_loop_prop( 'total' ) ) {
				
				while ( have_posts() ) {
					the_post();

			/**
			 * Hook: woocommerce_shop_loop.
			 */
			do_action( 'woocommerce_shop_loop' );

			wc_get_template_part( 'content', 'product' );
				}
			}

			woocommerce_product_loop_end();
			?>
				
			</div>
			<?php
			/**
			 * Hook: woocommerce_after_shop_loop.
			 *
			 * @hooked woocommerce_pagination - 10
			 */
			do_action( 'woocommerce_after_shop_loop' );
			} else {
				/**
				 * Hook: woocommerce_no_products_found.
				 *
				 * @hooked wc_no_products_found - 10
				 */
				do_action( 'woocommerce_no_products_found' );
			}

			/**
			 * Hook: woocommerce_after_main_content.
			 *
			 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
			 */
			do_action( 'woocommerce_after_main_content' );
			?>
	</div>


<?php get_footer(); ?>