<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
$fudee_redux_demo = get_option('redux_demo');
?>


<div class="col-xl-3 col-md-6">
  <div class="product-wrap">
    <div class="product-thumb">
      <?php
  /**
   * woocommerce_before_shop_loop_item hook.
   *
   * @hooked woocommerce_template_loop_product_link_open - 10
   */
  do_action( 'woocommerce_before_shop_loop_item' ); 

  /**
   * woocommerce_before_shop_loop_item_title hook.
   *
   * @hooked woocommerce_show_product_loop_sale_flash - 10
   * @hooked woocommerce_template_loop_product_thumbnail - 10
   */
  do_action( 'woocommerce_before_shop_loop_item_title' );?>
    </div>
    <div class="product-details">
      <h5><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h5>
      <?php 

  /**
   * woocommerce_after_shop_loop_item_title hook.
   *
   * @hooked woocommerce_template_loop_rating - 5
   * @hooked woocommerce_template_loop_price - 10
   */
  do_action( 'woocommerce_after_shop_loop_item_title' ); ?>
    </div>
    <div class="product-hover">
      <ul class="product-btns">
        <li><a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>"><i class="far fa-expand"></i></a></li>
        <li><a href="<?php the_permalink();?>"><i class="far fa-heart"></i></a></li>
        <li><a href="#"><i class="far fa-repeat"></i></a></li>
      </ul>
      <?php 

  /**
   * woocommerce_after_shop_loop_item hook.
   *
   * @hooked woocommerce_template_loop_product_link_close - 5
   * @hooked woocommerce_template_loop_add_to_cart - 10
   */
  do_action( 'woocommerce_after_shop_loop_item' );
  ?>
    </div>
  </div>
</div>

