<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header('shop'); ?>

<?php while ( have_posts() ) : the_post(); 
	?>

<?php if(isset($fudee_redux_demo['blog_image']['url']) && $fudee_redux_demo['blog_image']['url'] != ''){?>
    <section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo esc_url($fudee_redux_demo['blog_image']['url']);?>)">
<?php }else{?>    
    <section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo (get_template_directory_uri().'/assets/img/bg/breadcrumb-bg.jpg');?>)">
<?php } ?>   
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                    <div class="breadcrumb-content">
                    	<?php if(isset($fudee_redux_demo['product_title']) && $fudee_redux_demo['product_title'] != ''){?>
                       		<h3 class="title"><?php echo esc_attr($fudee_redux_demo['product_title']);?></h3>
                        <?php }else{ ?>
                        	<h3 class="title"><?php echo esc_html__( 'Product Details', 'fudee' )?></h3>
                        <?php } ?>
                        <ul>
                            <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__( 'Home', 'fudee' )?></a></li>
                            <?php if(isset($fudee_redux_demo['product_title']) && $fudee_redux_demo['product_title'] != ''){?>
                                <li class="active"><?php echo esc_attr($fudee_redux_demo['product_title']);?></li>
                            <?php }else{ ?>
                                <li class="active"><?php echo esc_html__( 'Product Details', 'fudee' )?></li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>


	<div class="wrapper light-wrapper single-product-content">
		<div class="container inner">
			<?php wc_get_template_part( 'content', 'single-product' ); ?>
			<!-- /.tab-content -->
		</div>
		<!-- /.container -->
	</div>

	<?php endwhile; // end of the loop. ?>
	<!-- /.wrapper -->
	

	<?php
	get_footer();

	/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
