<?php

namespace BdevsElementor\Widget;



use Elementor\Controls_Manager;

use Elementor\Group_Control_Typography;

use Elementor\Scheme_Typography;

use Elementor\Group_Control_Border;

use Elementor\Group_Control_Box_Shadow;



/**

 * Bdevs Elementor Widget.

 *

 * Elementor widget that inserts an embbedable content into the page, from any given URL.

 *

 * @since 1.0.0

 */

class BdevsTeam extends \Elementor\Widget_Base {



	/**

	 * Get widget name.

	 *

	 * Retrieve Bdevs Elementor widget name.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget name.

	 */

	public function get_name() {

		return 'bdevs-team';

	}



	/**

	 * Get widget title.

	 *

	 * Retrieve Bdevs Elementor widget title.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget title.

	 */

	public function get_title() {

		return __( 'Team Widget', 'bdevs-elementor' );

	}



	/**

	 * Get widget icon.

	 *

	 * Retrieve Bdevs Slider widget icon.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget icon.

	 */

	public function get_icon() {

		return 'eicon-favorite';

	}



	/**

	 * Get widget categories.

	 *

	 * Retrieve the list of categories the Bdevs Slider widget belongs to.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return array Widget categories.

	 */

	public function get_categories() {

		return [ 'bdevs-elementor' ];

	}



	public function get_keywords() {

		return [ 'bdevs-team' ];

	}



	public function get_script_depends() {

		return [ 'bdevs-elementor'];

	}



	// BDT Position

	protected function element_pack_position() {

	    $position_options = [

	        ''              => esc_html__('Default', 'bdevs-elementor'),

	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,

	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,

	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,

	        'center'        => esc_html__('Center', 'bdevs-elementor') ,

	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,

	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,

	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,

	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,

	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,

	    ];



	    return $position_options;

	}



	protected function _register_controls() {

		$this->start_controls_section(

			'section_content_team',

			[

				'label' => esc_html__( 'Team Area', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'chose_style',

			[

				'label'     => esc_html__( 'Chose Style', 'bdevs-elementor' ),

				'type'      => Controls_Manager::SELECT,

				'options'   => [

					'team_style_1'  => esc_html__( 'Team Style 1', 'bdevs-elementor' ),

					'team_style_2' => esc_html__( 'Team Style 2', 'bdevs-elementor' ),

				],

				'default'   => 'team_style_1',

			]

		);



		$this->add_control(

			'icon_image',

			[

				'label'   => esc_html__( 'Icon Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Icon Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'heading',

			[

				'label'       => __( 'Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'sub_heading',

			[

				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'tabs',

			[

				'label' => esc_html__( 'Team Items', 'bdevs-elementor' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => [	

					[

						'name'    => 'tab_image',

						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),

						'type'    => Controls_Manager::MEDIA,

						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),

					],

					[

						'name'        => 'tab_title',

						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_subtitle',

						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_link',

						'label'       => esc_html__( 'Link', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Link' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_facebook',

						'label'       => esc_html__( 'Facebook Link', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Facebook Link' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_twitter',

						'label'       => esc_html__( 'Twitter Link', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Twitter Link' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_pinterest',

						'label'       => esc_html__( 'Pinterest Link', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Pinterest Link' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_instagram',

						'label'       => esc_html__( 'Instagram Link', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Instagram Link' , 'bdevs-elementor' ),

						'label_block' => true,

					],

				],

			]

		);



		$this->end_controls_section();





		$this->start_controls_section(

			'section_content_team_2',

			[

				'label' => esc_html__( 'Team Style 2', 'bdevs-elementor' ),

				

			]

		);



		$this->add_control(

			'tabs_2',

			[

				'label' => esc_html__( 'Team Items', 'bdevs-elementor' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => [	

					[

						'name'    => 'tab_image',

						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),

						'type'    => Controls_Manager::MEDIA,

						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),

					],

					[

						'name'        => 'tab_title',

						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_subtitle',

						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_facebook',

						'label'       => esc_html__( 'Facebook Link', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Facebook Link' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_twitter',

						'label'       => esc_html__( 'Twitter Link', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Twitter Link' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_pinterest',

						'label'       => esc_html__( 'Pinterest Link', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Pinterest Link' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_instagram',

						'label'       => esc_html__( 'Instagram Link', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Instagram Link' , 'bdevs-elementor' ),

						'label_block' => true,

					],

				],

			]

		);



		$this->end_controls_section();







		$this->start_controls_section(

			'section_content_layout',

			[

				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),

			]

		);



		$this->add_responsive_control(

			'align',

			[

				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),

				'type'    => Controls_Manager::CHOOSE,

				'options' => [

					'left' => [

						'title' => esc_html__( 'Left', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-left',

					],

					'center' => [

						'title' => esc_html__( 'Center', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-center',

					],

					'right' => [

						'title' => esc_html__( 'Right', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-right',

					],

					'justify' => [

						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-justify',

					],

				],

				'prefix_class' => 'elementor%s-align-',

				'description'  => 'Use align to match position',

				'default'      => 'center',

			]

		);



		$this->add_control(

			'show_heading',

			[

				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);	



		$this->add_control(

			'show_sub_heading',

			[

				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);		



		$this->add_control(

			'show_image',

			[

				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);



		$this->end_controls_section();







	}



	public function render() {

		$settings  = $this->get_settings_for_display();

		$chose_style = $settings['chose_style'];

		?>



		<?php if( $chose_style == 'team_style_1' ): ?>

		

		<div class="team-area pb-130">



			<div class="container">



				<div class="row justify-content-center mb-50">



					<div class="col-xl-6 col-lg-8 col-md-10">



						<div class="section-title text-center">

							

							<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>

							<h5><?php echo wp_kses_post($settings['sub_heading']); ?></h5>

							<?php endif; ?>

							

							<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>

							<h3><?php echo wp_kses_post($settings['heading']); ?></h3>

							<?php endif; ?>

							

							<?php if (( '' !== $settings['icon_image']['url'] ) && ( $settings['show_image'] )): ?>

							<div class="icon">



								<img src="<?php echo wp_kses_post($settings['icon_image']['url']); ?>" alt="icon">



							</div>

							<?php endif; ?>



						</div>



					</div>



				</div>



				<div class="row">



					<div class="col-xl-12">



						<div class="team-slider team-slider-2">



							<?php foreach ( $settings['tabs'] as $item ) : ?>



							<div class="team-slide">



								<div class="team-wrap">

									

									<?php if ( '' !== $item['tab_image']['url'] ) : ?>



									<div class="team-thumb">



										<a href="<?php echo wp_kses_post($item['tab_link']); ?>">



											<img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt="team">



										</a>



									</div>



									<?php endif; ?>



									<div class="team-details">

										

										<?php if ( '' !== $item['tab_title'] ) : ?>

										<h4><a href="<?php echo wp_kses_post($item['tab_link']); ?>"><?php echo wp_kses_post($item['tab_title']); ?></a></h4>

										<?php endif; ?>

										

										<?php if ( '' !== $item['tab_subtitle'] ) : ?>

										<p><?php echo wp_kses_post($item['tab_subtitle']); ?></p>

										<?php endif; ?>



										<div class="social">

											

											<?php if ( '' !== $item['tab_facebook'] ) : ?>

											<a href="<?php echo wp_kses_post($item['tab_facebook']); ?>" class="facebook"><i class="fab fa-facebook-f"></i></a>

											<?php endif; ?>



											<?php if ( '' !== $item['tab_twitter'] ) : ?>

											<a href="<?php echo wp_kses_post($item['tab_twitter']); ?>" class="twitter"><i class="fab fa-twitter"></i></a>

											<?php endif; ?>

											

											<?php if ( '' !== $item['tab_pinterest'] ) : ?>

											<a href="<?php echo wp_kses_post($item['tab_pinterest']); ?>" class="pinterest"><i class="fab fa-pinterest-p"></i></a>

											<?php endif; ?>

											

											<?php if ( '' !== $item['tab_instagram'] ) : ?>

											<a href="<?php echo wp_kses_post($item['tab_instagram']); ?>" class="instagram"><i class="fab fa-instagram"></i></a>

											<?php endif; ?>



										</div>



									</div>



								</div>



							</div>



							<?php endforeach; ?>



						</div>



					</div>



				</div>



			</div>



		</div>



		<?php elseif( $chose_style == 'team_style_2' ): ?>



			<div class="product-area pt-100 pb-40">



				<div class="container">



					<div class="row">



						<?php foreach ( $settings['tabs_2'] as $item ) : ?>



						<div class="col-xl-3 col-md-6">



							<div class="team-wrap-2">



								<div class="team-thumb">



									<?php if ( '' !== $item['tab_image']['url'] ) : ?>

									<img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt="team">

									<?php endif; ?>



									<div class="social">



										<?php if ( '' !== $item['tab_facebook'] ) : ?>

											<a href="<?php echo wp_kses_post($item['tab_facebook']); ?>" class="facebook"><i class="fab fa-facebook-f"></i></a>

											<?php endif; ?>



											<?php if ( '' !== $item['tab_twitter'] ) : ?>

											<a href="<?php echo wp_kses_post($item['tab_twitter']); ?>" class="twitter"><i class="fab fa-twitter"></i></a>

											<?php endif; ?>

											

											<?php if ( '' !== $item['tab_pinterest'] ) : ?>

											<a href="<?php echo wp_kses_post($item['tab_pinterest']); ?>" class="pinterest"><i class="fab fa-pinterest-p"></i></a>

											<?php endif; ?>

											

											<?php if ( '' !== $item['tab_instagram'] ) : ?>

											<a href="<?php echo wp_kses_post($item['tab_instagram']); ?>" class="instagram"><i class="fab fa-instagram"></i></a>

											<?php endif; ?>



									</div>



								</div>



								<div class="team-details">



									<?php if ( '' !== $item['tab_title'] ) : ?>

										<h4><a href="<?php echo wp_kses_post($item['tab_link']); ?>"><?php echo wp_kses_post($item['tab_title']); ?></a></h4>

										<?php endif; ?>

										

										<?php if ( '' !== $item['tab_subtitle'] ) : ?>

										<p><?php echo wp_kses_post($item['tab_subtitle']); ?></p>

										<?php endif; ?>



								</div>



							</div>



						</div>



						<?php endforeach; ?>



					</div>



				</div>



			</div>



		<?php endif; ?>


<?php if (is_admin()) { ?>
<script type="text/javascript">
	if (jQuery(".team-slider").length > 0) {

		$('.team-slider').slick({

			slidesToShow: 4,

			slidesToScroll: 1,

			autoplay: true,

			autoplaySpeed: 10000,

			dots: false,

			arrows: true,

			prevArrow: '<button type="button" class="slick-prev"><i class="far fa-arrow-left"></i></button>',

			nextArrow: '<button type="button" class="slick-next"><i class="far fa-arrow-right"></i></i></button>',

			responsive: [

				{

					breakpoint: 1200,

					settings: {

						slidesToShow: 3,

						arrows: false,

					}

				},

				{

					breakpoint: 991,

					settings: {

						slidesToShow: 2,

						arrows: false,

						centerMode: false,

					}

				},

				{

					breakpoint: 767,

					settings: {

						slidesToShow: 1,

						arrows: false,

						centerMode: false,

					}

				}

			]

		});

	}
</script>
<?php }  ?>
	<?php

	}



}